# $Id: gwyddion3.spec.in 28743 2025-10-30 17:29:29Z yeti-dn $
Name:          gwyddion
Version:       3.7
Release:       1%{?dist}
Summary:       An SPM data visualization and analysis tool

Group:         Applications/Engineering
License:       GPLv2+
URL:           https://gwyddion.net/
Source0:       http://gwyddion.net/download/%{version}/%{name}-%{version}.tar.xz
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root-%(id -un)
Requires(pre):    /sbin/ldconfig
Requires(postun): /sbin/ldconfig

BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: pkgconfig(gtk+-3.0) >= 3.24
BuildRequires: pkgconfig(glib-2.0) >= 2.68
BuildRequires: pkgconfig(gdk-pixbuf-2.0) >= 2.4
BuildRequires: pkgconfig(pango) >= 1.12
BuildRequires: pkgconfig(cairo) >= 1.12
BuildRequires: pkgconfig(fftw3) >= 3.3
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: zlib-devel
BuildRequires: pkgconfig(libwebp)
BuildRequires: pkgconfig(OpenEXR)
BuildRequires: pkgconfig(cfitsio)
BuildRequires: pkgconfig(libpng)
BuildRequires: gettext
BuildRequires: desktop-file-utils >= 0.9
BuildRequires: findutils
BuildRequires: pkgconfig(xmu)
BuildRequires: pkgconfig(gtksourceview-3.0)
BuildRequires: pkgconfig(libzip)
BuildRequires: pkgconfig(jansson)
BuildRequires: hdf5-devel
BuildRequires: sed
BuildRequires: python3

%if 0%{?suse_version}
BuildRequires: pkg-config
%else
BuildRequires: pkgconfig
%endif

# __brp_python_bytecompile is for F27 and older
# __python redefinition for 28
# _python_bytecompile_extra for 29
# Since it is a mess which changes with every version, just try to disable
# byte compilation.
BuildRequires: perl >= 5.005
%if 0%{?fedora}
BuildRequires: perl-podlators
BuildRequires: rubypick
%global _python_bytecompile_extra 0
%global __python %{__python2}
%undefine __brp_python_bytecompile
%endif
%if 0%{?rhel}
BuildRequires: perl-podlators
BuildRequires: rubypick
%global __python %{__python2}
%undefine __brp_python_bytecompile
%endif

%define configureopts %{nil}

# The only packaged perl module is private, don't expose it.
%define __perl_provides %{nil}

%define pkglibdir %{_libdir}/%{name}
%define pkgdocdir %{_docdir}/%{name}
%define pkgdatadir %{_datadir}/%{name}
%define pkgincludedir %{_includedir}/%{name}
%if 0%{?suse_version}
%define docdirconfigurearg --docdir=%{pkgdocdir}
%else
%define docdirconfigurearg %{nil}
%endif
%define gtkdocdir %{_datadir}/gtk-doc/html


%package devel
Summary:       Headers, libraries and tools for Gwyddion module development
Group:         Development/Libraries
Requires:      %{name}%{?_isa} = %{version}
# This pulls everything else
Requires:      gtk3-devel%{?_isa} >= 3.24
Requires:      gtkglext-devel%{?_isa}
Requires:      perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))


%description
Gwyddion is a modular SPM (Scanning Probe Microsopy) data visualization and
analysis tool written with Gtk+.

It can be used for all most frequently used data processing operations
including: leveling, false color plotting, shading, filtering, denoising, data
editing, integral transforms, grain analysis, profile extraction, fractal
analysis, and many more.  The program is primarily focused on SPM data analysis
(e.g. data obtained from AFM, STM, NSOM, and similar microscopes).  However, it
can also be used for analysis of SEM (Scanning Electron Microscopy) data or any
other 2D data.


%description devel
Header files, libraries and tools for Gwyddion module development.
This package also contains the API docmentation.


%prep
%setup -q
# Don't install .la files.
sed -i -e '/# Install the pseudo-library/,/^$/d' ltmain.sh


%build
%configure %configureopts %docdirconfigurearg --disable-rpath --without-kde4-thumbnailer
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
# Install the icon to the hicolor theme *and* to /usr/share/pixmaps because
# some distros expect it in one place, some in another.
# FIXME: No longer correct.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/pixmaps
install pixmaps/%{name}.png $RPM_BUILD_ROOT%{_datadir}/pixmaps
%find_lang %{name}

# Get rid of .la files if some silly distros (hello Mandriva) overwrote our
# fixed libtool with some crap.
find $RPM_BUILD_ROOT -name \*.la -print0 | xargs -0 rm -f


%clean
rm -rf $RPM_BUILD_ROOT


%post
/sbin/ldconfig
update-mime-database %{_datadir}/mime &>/dev/null || :
update-desktop-database &>/dev/null || :


%postun
/sbin/ldconfig
update-mime-database %{_datadir}/mime &>/dev/null || :
update-desktop-database &>/dev/null || :


%files -f %{name}.lang
%defattr(755,root,root)
%{_bindir}/%{name}
%{_bindir}/%{name}-thumbnailer
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README THANKS
%{pkgdatadir}/icons/hicolor/16x16/*
%{pkgdatadir}/icons/hicolor/18x18/*
%{pkgdatadir}/icons/hicolor/20x20/*
%{pkgdatadir}/icons/hicolor/24x24/*
%{pkgdatadir}/icons/hicolor/60x60/*
%{pkgdatadir}/icons/hicolor/index.theme
%{pkgdatadir}/drawings/*.svg
%{pkgdatadir}/pixmaps/*.ico
%{pkgdatadir}/pixmaps/*.png
%{pkgdatadir}/gradients/*
%{pkgdatadir}/glmaterials/*
%{pkgdatadir}/pygwy/*
%{pkgdatadir}/ui/*
%{pkgdatadir}/user-guide-modules
%dir %{pkgdatadir}/icons/hicolor/16x16
%dir %{pkgdatadir}/icons/hicolor/18x18
%dir %{pkgdatadir}/icons/hicolor/20x20
%dir %{pkgdatadir}/icons/hicolor/24x24
%dir %{pkgdatadir}/icons/hicolor/60x60
%dir %{pkgdatadir}/icons/hicolor
%dir %{pkgdatadir}/icons
%dir %{pkgdatadir}/drawings
%dir %{pkgdatadir}/pixmaps
%dir %{pkgdatadir}/gradients
%dir %{pkgdatadir}/glmaterials
%dir %{pkgdatadir}/pygwy
%dir %{pkgdatadir}/ui
%dir %{pkgdatadir}
%{_mandir}/man1/%{name}.1*
%{_mandir}/man1/%{name}-thumbnailer.1*
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/metainfo/net.gwyddion.Gwyddion.appdata.xml
%{pkglibdir}/modules/cmap/*.so
%{pkglibdir}/modules/file/*.so
%{pkglibdir}/modules/graph/*.so
%{pkglibdir}/modules/process/*.so
%{pkglibdir}/modules/synth/*.so
%{pkglibdir}/modules/tool/*.so
%{pkglibdir}/modules/volume/*.so
%{pkglibdir}/modules/xyz/*.so
%{pkglibdir}/modules/*.so
%dir %{pkglibdir}/modules/cmap
%dir %{pkglibdir}/modules/file
%dir %{pkglibdir}/modules/graph
%dir %{pkglibdir}/modules/process
%dir %{pkglibdir}/modules/synth
%dir %{pkglibdir}/modules/tool
%dir %{pkglibdir}/modules/volume
%dir %{pkglibdir}/modules/xyz
%dir %{pkglibdir}/modules
%dir %{pkglibdir}
%{_libdir}/*.so.*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/thumbnailers/%{name}.thumbnailer
%{_datadir}/gtksourceview-2.0/language-specs/pygwy.lang

%files devel
%defattr(-,root,root)
%doc devel-docs/CODING-STANDARDS
%doc data/%{name}.vim
%{pkgincludedir}/libgwyddion/*.h
%{pkgincludedir}/libprocess/*.h
%{pkgincludedir}/libgwyui/*.h
%{pkgincludedir}/libgwyapp/*.h
%dir %{pkgincludedir}/libgwyddion
%dir %{pkgincludedir}/libprocess
%dir %{pkgincludedir}/libgwyui
%dir %{pkgincludedir}/libgwyapp
%dir %{pkgincludedir}
%{_libdir}/*.so
%{python_sitearch}/gwy.so
%{_libdir}/pkgconfig/libgwy*.pc
%dir %{_libdir}/pkgconfig
# Documentation
%doc %{gtkdocdir}/libgwyapp/*
%doc %{gtkdocdir}/libgwyprocess/*
%doc %{gtkdocdir}/libgwyddion/*
%doc %{gtkdocdir}/libgwyui/*
%doc %dir %{gtkdocdir}/libgwyapp
%doc %dir %{gtkdocdir}/libgwyprocess
%doc %dir %{gtkdocdir}/libgwyddion
%doc %dir %{gtkdocdir}/libgwyui
%doc %dir %{gtkdocdir}
%doc %dir %{_datadir}/gtk-doc
%{pkglibdir}/include/gwyconfig.h
%dir %{pkglibdir}/include

%changelog
* Tue Aug  8 2017 Yeti <yeti@gwyddion.net> - 3.7-1
- hello rpmlint, this package is partially generated
