#pragma once
/*
 *  $Id: app-image-window.h 28653 2025-10-16 14:17:16Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti)
 *  E-mail: yeti@gwyddion.net
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_APP_IMAGE_WINDOW_H__
#define __GWYAPP_APP_IMAGE_WINDOW_H__

#include <libgwyui/gwydatawindow.h>
#include <libgwyapp/file.h>

G_BEGIN_DECLS

#define GWY_TYPE_APP_IMAGE_WINDOW             (gwy_app_image_window_get_type())
#define GWY_APP_IMAGE_WINDOW(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_APP_IMAGE_WINDOW, GwyAppImageWindow))
#define GWY_APP_IMAGE_WINDOW_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_APP_IMAGE_WINDOW, GwyAppImageWindowClass))
#define GWY_IS_APP_IMAGE_WINDOW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_APP_IMAGE_WINDOW))
#define GWY_IS_APP_IMAGE_WINDOW_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_APP_IMAGE_WINDOW))
#define GWY_APP_IMAGE_WINDOW_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_APP_IMAGE_WINDOW, GwyAppImageWindowClass))

typedef struct _GwyAppImageWindow        GwyAppImageWindow;
typedef struct _GwyAppImageWindowClass   GwyAppImageWindowClass;
typedef struct _GwyAppImageWindowPrivate GwyAppImageWindowPrivate;

struct _GwyAppImageWindow {
    GwyDataWindow parent_instance;
    GwyAppImageWindowPrivate *priv;
};

struct _GwyAppImageWindowClass {
    GwyDataWindowClass parent_class;

    /*< private >*/
    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
};

GType       gwy_app_image_window_get_type     (void)                       G_GNUC_CONST;
GtkWindow*  gwy_app_image_window_new          (GwyFile *file,
                                               GwyDataKind data_kind,
                                               gint id)                    G_GNUC_MALLOC;
GwyFile*    gwy_app_image_window_get_file     (GwyAppImageWindow *window);
GwyDataKind gwy_app_image_window_get_data_kind(GwyAppImageWindow *window);
gint        gwy_app_image_window_get_id       (GwyAppImageWindow *window);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
