/*
 *  $Id: data-browser-aux.c 28698 2025-10-21 15:53:23Z yeti-dn $
 *  Copyright (C) 2006-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* This file contains helpers that used to be in data-browser.c because they did not belong anywhere else and are
 * somehow related to data management.  However, they do not need internal knowledge of the data browser and do not
 * work with GwyAppDataBrowser, GwyAppDataProxy and similar structs. */

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#include "libgwyddion/macros.h"
#include "libgwyddion/utils.h"
#include "libgwyddion/gwycontainer.h"
#include "libgwyui/gwyui.h"

#include "libgwyapp/gwyapp.h"
#include "libgwyapp/module-utils.h"
#include "libgwyapp/gwyappinternal.h"

/* TODO TODO TODO: Implement merge again. */
#if 0
static const struct {
    GwyAppKeyType type;
    GwyDataKind data_kind;
} page_data_keys[] = {
    { KEY_IS_DATA,    GWY_PAGE_CHANNELS,   },
    { KEY_IS_GRAPH,   GWY_PAGE_GRAPHS,     },
    { KEY_IS_SPECTRA, GWY_PAGE_SPECTRA,    },
    { KEY_IS_BRICK,   GWY_PAGE_VOLUMES,    },
    { KEY_IS_SURFACE, GWY_PAGE_XYZS,       },
    { KEY_IS_LAWN,    GWY_FILE_CMAP, },
};

void
_gwy_app_data_merge_gather(GQuark quark,
                           G_GNUC_UNUSED GValue *gvalue,
                           gpointer user_data)
{
    GList **ids = (GList**)user_data;
    GwyAppKeyType type;
    gint id, data_kind;
    guint i;

    id = _gwy_app_analyse_data_key(g_quark_to_string(quark), &type, NULL);
    for (i = 0; i < G_N_ELEMENTS(page_data_keys); i++) {
        if (type == page_data_keys[i].type) {
            data_kind = page_data_keys[i].data_kind;
            gwy_debug("adding %d to data_kind %d", id, data_kind);
            ids[data_kind] = g_list_prepend(ids[data_kind], GINT_TO_POINTER(id));
            return;
        }
    }
}

void
_gwy_app_data_merge_copy_1(GQuark quark,
                           GValue *gvalue,
                           gpointer user_data)
{
    GHashTable **map = (GHashTable**)user_data;
    GwyAppKeyType type;
    gpointer idp, id2p;
    gint id, data_kind;
    guint i;

    id = _gwy_app_analyse_data_key(g_quark_to_string(quark), &type, NULL);
    idp = GINT_TO_POINTER(id);
    for (i = 0; i < G_N_ELEMENTS(page_data_keys); i++) {
        if (type == page_data_keys[i].type) {
            data_kind = page_data_keys[i].data_kind;
            if (!g_hash_table_lookup_extended(map[data_kind], idp, NULL, &id2p))
                goto fail;
            quark = _gwy_app_get_page_data_key_for_id(GPOINTER_TO_INT(id2p), data_kind);
            gwy_container_set_object((GwyContainer*)map[GWY_NPAGES], quark, g_value_get_object(gvalue));
            return;
        }
    }
    /* Handle these in gwy_app_data_merge_copy_2() */
    return;

fail:
    g_warning("%s does not map to any new location", g_quark_to_string(quark));
}

void
_gwy_app_data_merge_copy_2(GQuark quark,
                           GValue *gvalue,
                           gpointer user_data)
{
    GHashTable **map = (GHashTable**)user_data;
    GwyContainer *dest;
    const gchar *strkey;
    GwyAppKeyType type;
    gpointer idp, id2p;
    gint id, id2, data_kind;
    guint len, i;
    gboolean visibility = FALSE;
    gchar buf[80];

    strkey = g_quark_to_string(quark);
    if (gwy_strequal(strkey, "/0/graph/lastid"))
        return;

    /* Handle visibility by stripping "/visible" from the key before analysis */
    if (g_str_has_suffix(strkey, "/visible")) {
        gchar *vstrkey;

        vstrkey = g_strndup(strkey, strlen(strkey) - strlen("/visible"));
        id = _gwy_app_analyse_data_key(vstrkey, &type, &len);
        g_free(vstrkey);
        visibility = TRUE;
    }
    else
        id = _gwy_app_analyse_data_key(strkey, &type, &len);

    if (type == KEY_IS_FILENAME)
        return;
    if (id < 0)
        goto fail;

    idp = GINT_TO_POINTER(id);
    dest = (GwyContainer*)map[GWY_NPAGES];

    /* Visibilty */
    for (i = 0; i < G_N_ELEMENTS(page_data_keys); i++) {
        if (type == page_data_keys[i].type) {
            data_kind = page_data_keys[i].data_kind;
            if (visibility) {
                if (!g_hash_table_lookup_extended(map[data_kind], idp, NULL, &id2p))
                    goto fail;
                quark = _gwy_app_get_page_data_key_for_id(GPOINTER_TO_INT(id2p), data_kind);
                g_snprintf(buf, sizeof(buf), "%s/visible", g_quark_to_string(quark));
                if (g_value_get_boolean(gvalue))
                    gwy_container_set_boolean_by_name(dest, buf, TRUE);
            }
            return;
        }
    }

    switch (type) {
        case KEY_IS_MASK:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        quark = gwy_app_get_mask_key_for_id(id2);
        gwy_container_set_object(dest, quark, g_value_get_object(gvalue));
        break;

        case KEY_IS_SHOW:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        quark = gwy_file_key_image_picture(id2);
        gwy_container_set_object(dest, quark, g_value_get_object(gvalue));
        break;

        case KEY_IS_SPS_REF:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        id = g_value_get_int(gvalue);
        idp = GINT_TO_POINTER(id);
        /* Ignore references to nonexistent sps ids silently */
        if (g_hash_table_lookup_extended(map[GWY_PAGE_SPECTRA], idp, NULL, &id2p)) {
            g_snprintf(buf, sizeof(buf), "/%d/data/sps-is", id2);
            id2 = GPOINTER_TO_INT(id2p);
            gwy_container_set_int32_by_name(dest, buf, id2);
        }
        break;

        case KEY_IS_TITLE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_data_title_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_PALETTE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_data_palette_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_MASK_COLOR:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/mask%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_SELECT:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/data/select%s", id2, strkey + len);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_RANGE_TYPE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_enum(dest, gwy_file_key_image_color_mapping(id2), g_value_get_int(gvalue));
        break;

        case KEY_IS_RANGE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/base%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_REAL_SQUARE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/data/realsquare", id2);
        gwy_container_set_boolean_by_name(dest, buf, g_value_get_boolean(gvalue));
        break;

        case KEY_IS_CHANNEL_META:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_data_meta_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_CHANNEL_LOG:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/data/log", id2);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_DATA_VIEW_SCALE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/data%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_GL_SETUP:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/3d/setup", id2);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_GL_LABEL:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/3d%s", id2, strkey + len);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_GL_PALETTE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/3d/palette", id2);
        gwy_container_set_string_by_name(dest, buf, g_value_dup_string(gvalue));
        break;

        case KEY_IS_GL_MATERIAL:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/3d/material", id2);
        gwy_container_set_string_by_name(dest, buf, g_value_dup_string(gvalue));
        break;

        case KEY_IS_GL_VIEW_SCALE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_GL_VIEW_SIZE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_CHANNELS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), "/%d/%s", id2, strkey + len);
        gwy_container_set_int32_by_name(dest, buf, g_value_get_int(gvalue));
        break;

        case KEY_IS_GRAPH_VIEW_SCALE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_GRAPHS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), OLD_GRAPH_PREFIX "/%d%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_GRAPH_VIEW_SIZE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_GRAPHS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), OLD_GRAPH_PREFIX "/%d%s", id2, strkey + len);
        gwy_container_set_int32_by_name(dest, buf, g_value_get_int(gvalue));
        break;

        case KEY_IS_BRICK_TITLE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_VOLUMES], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_brick_title_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_BRICK_PREVIEW:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_VOLUMES], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_brick_preview_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_BRICK_PREVIEW_PALETTE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_VOLUMES], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_brick_palette_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_BRICK_META:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_VOLUMES], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_brick_meta_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_BRICK_LOG:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_VOLUMES], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), BRICK_PREFIX "/%d/log", id2);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_BRICK_VIEW_SCALE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_VOLUMES], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), BRICK_PREFIX "/%d%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_SURFACE_TITLE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_surface_title_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_SURFACE_PREVIEW:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_surface_preview_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_SURFACE_PREVIEW_PALETTE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_surface_palette_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_SURFACE_META:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_surface_meta_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_SURFACE_LOG:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), SURFACE_PREFIX "/%d/log", id2);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_SURFACE_VIEW_SCALE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), SURFACE_PREFIX "/%d%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        case KEY_IS_SURFACE_VIEW_SIZE:
        if (!g_hash_table_lookup_extended(map[GWY_PAGE_XYZS], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), SURFACE_PREFIX "/%d%s", id2, strkey + len);
        gwy_container_set_int32_by_name(dest, buf, g_value_get_int(gvalue));
        break;

        case KEY_IS_LAWN_TITLE:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_lawn_title_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_LAWN_PREVIEW:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_lawn_preview_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_LAWN_PREVIEW_PALETTE:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_string(dest, gwy_app_get_lawn_palette_key_for_id(id2), g_value_dup_string(gvalue));
        break;

        case KEY_IS_LAWN_REAL_SQUARE:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), LAWN_PREFIX "/%d/preview/realsquare", id2);
        gwy_container_set_boolean_by_name(dest, buf, g_value_get_boolean(gvalue));
        break;

        case KEY_IS_LAWN_META:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        gwy_container_set_object(dest, gwy_app_get_lawn_meta_key_for_id(id2), g_value_get_object(gvalue));
        break;

        case KEY_IS_LAWN_LOG:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), LAWN_PREFIX "/%d/log", id2);
        gwy_container_set_object_by_name(dest, buf, g_value_get_object(gvalue));
        break;

        case KEY_IS_LAWN_VIEW_SCALE:
        if (!g_hash_table_lookup_extended(map[GWY_FILE_CMAP], idp, NULL, &id2p))
            goto fail;
        id2 = GPOINTER_TO_INT(id2p);
        g_snprintf(buf, sizeof(buf), LAWN_PREFIX "/%d%s", id2, strkey + len);
        gwy_container_set_double_by_name(dest, buf, g_value_get_double(gvalue));
        break;

        default:
        goto fail;
        break;
    }
    return;

fail:
    g_warning("%s (%u) does not map to any new location, cannot map it generically because the current key "
              "organization is a mess",
              strkey, type);
}
#endif

#if 0
/* Preserve for reference. Make sure 1.x titles are converted upon import. */
gchar*
_gwy_app_figure_out_image_title(GwyContainer *data, gint channel)
{
    const gchar *title = NULL;
    gchar buf[32];

    g_return_val_if_fail(GWY_IS_CONTAINER(data), NULL);
    g_return_val_if_fail(channel >= 0, NULL);

    gwy_container_gis_string(data, gwy_app_get_data_title_key_for_id(channel), &title);
    if (!title) {
        g_snprintf(buf, sizeof(buf), "/%d/data/untitled", channel);
        gwy_container_gis_string_by_name(data, buf, &title);
    }
    /* Support 1.x titles */
    if (!title)
        gwy_container_gis_string_by_name(data, "/filename/title", &title);

    if (title)
        return g_strdup(title);

    return g_strdup_printf(_("Unknown channel %d"), channel + 1);
}
#endif

#if 0
void
_gwy_app_update_gl_window_title(GwyGLWindow *glwindow, gint id)
{
    GtkWidget *glview;
    GwyContainer *data;
    gchar *title, *ctitle;

    glview = gwy_gl_window_get_gl_view(glwindow);
    data = gwy_gl_view_get_data(GWY_GL_VIEW(glview));
    ctitle = _gwy_app_figure_out_image_title(data, id);
    title = g_strconcat("3D ", ctitle, NULL);
    gtk_window_set_title(GTK_WINDOW(glwindow), title);
    g_free(title);
    g_free(ctitle);
}
#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
