#pragma once
/*
 *  $Id: int-list.h 28903 2025-11-24 15:49:51Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*< private_header >*/

#ifndef __GWY_INT_LIST_H__
#define __GWY_INT_LIST_H__

G_BEGIN_DECLS

typedef struct {
    guint size;
    guint len;
    gssize *data;
} IntList;

G_GNUC_UNUSED
static inline IntList*
int_list_new(guint prealloc)
{
    IntList *list = g_new0(IntList, 1);
    prealloc = MAX(prealloc, 16);
    list->size = prealloc;
    list->data = g_new(gssize, list->size);
    return list;
}

G_GNUC_UNUSED
static inline void
int_list_add(IntList *list, gint i)
{
    if (G_UNLIKELY(list->len == list->size)) {
        list->size = MAX(2*list->size, 16);
        list->data = g_renew(gssize, list->data, list->size);
    }

    list->data[list->len] = i;
    list->len++;
}

G_GNUC_UNUSED
static inline void
int_list_add_unique(IntList **plist, gint i)
{
    IntList *list;
    guint j;

    if (!*plist)
        *plist = int_list_new(0);

    list = *plist;
    for (j = 0; j < list->len; j++) {
        if (list->data[j] == i)
            return;
    }
    int_list_add(list, i);
}

G_GNUC_UNUSED
static inline void
int_list_free(IntList *list)
{
    g_free(list->data);
    g_free(list);
}

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
