#pragma once
/*
 *  $Id: inttrans.h 28798 2025-11-05 11:40:26Z yeti-dn $
 *  Copyright (C) 2003-2022 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_INTTRANS_H__
#define __GWY_INTTRANS_H__

#include <libgwyddion/field.h>
#include <libgwyddion/cwt.h>

G_BEGIN_DECLS

void gwy_line_fft             (GwyLine *rsrc,
                               GwyLine *isrc,
                               GwyLine *rdest,
                               GwyLine *idest,
                               GwyWindowingType windowing,
                               GwyTransformDirection direction,
                               gboolean preserverms,
                               gint level);
void gwy_line_part_fft        (GwyLine *rsrc,
                               GwyLine *isrc,
                               GwyLine *rdest,
                               GwyLine *idest,
                               gint from,
                               gint len,
                               GwyWindowingType windowing,
                               GwyTransformDirection direction,
                               gboolean preserverms,
                               gint level);
void gwy_line_fft_raw         (GwyLine *rsrc,
                               GwyLine *isrc,
                               GwyLine *rdest,
                               GwyLine *idest,
                               GwyTransformDirection direction);
void gwy_line_zoom_fft        (GwyLine *rsrc,
                               GwyLine *isrc,
                               GwyLine *rdest,
                               GwyLine *idest,
                               gint m,
                               gdouble f0,
                               gdouble f1);
void gwy_field_zoom_fft       (GwyField *rsrc,
                               GwyField *isrc,
                               GwyField *rdest,
                               GwyField *idest,
                               gint mx,
                               gint my,
                               gdouble fx0,
                               gdouble fy0,
                               gdouble fx1,
                               gdouble fy1);
void gwy_field_fft_1d         (GwyField *rin,
                               GwyField *iin,
                               GwyField *rout,
                               GwyField *iout,
                               GwyOrientation orientation,
                               GwyWindowingType windowing,
                               GwyTransformDirection direction,
                               gboolean preserverms,
                               gint level);
void gwy_field_area_fft_1d    (GwyField *rin,
                               GwyField *iin,
                               GwyField *rout,
                               GwyField *iout,
                               gint col,
                               gint row,
                               gint width,
                               gint height,
                               GwyOrientation orientation,
                               GwyWindowingType windowing,
                               GwyTransformDirection direction,
                               gboolean preserverms,
                               gint level);
void gwy_field_fft_1d_raw     (GwyField *rin,
                               GwyField *iin,
                               GwyField *rout,
                               GwyField *iout,
                               GwyOrientation orientation,
                               GwyTransformDirection direction);
void gwy_field_fft_2d         (GwyField *rin,
                               GwyField *iin,
                               GwyField *rout,
                               GwyField *iout,
                               GwyWindowingType windowing,
                               GwyTransformDirection direction,
                               gboolean preserverms,
                               gint level);
void gwy_field_area_fft_2d    (GwyField *rin,
                               GwyField *iin,
                               GwyField *rout,
                               GwyField *iout,
                               gint col,
                               gint row,
                               gint width,
                               gint height,
                               GwyWindowingType windowing,
                               GwyTransformDirection direction,
                               gboolean preserverms,
                               gint level);
void gwy_field_fft_2d_raw     (GwyField *rin,
                               GwyField *iin,
                               GwyField *rout,
                               GwyField *iout,
                               GwyTransformDirection direction);
void gwy_field_fft_2d_center  (GwyField *field);
void gwy_field_fft_2d_decenter(GwyField *field);
void gwy_field_fft_postprocess(GwyField *field,
                               gboolean humanize);
void gwy_field_fft_filter_1d  (GwyField *field,
                               GwyField *result_field,
                               GwyLine *weights,
                               GwyOrientation orientation,
                               GwyInterpolationType interpolation);
void gwy_line_fft_window      (GwyLine *line,
                               GwyWindowingType windowing);
void gwy_field_fft_window     (GwyField *field,
                               GwyWindowingType windowing);
void gwy_field_fft_window_1d  (GwyField *field,
                               GwyOrientation orientation,
                               GwyWindowingType windowing);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
