#pragma once
/*
 *  $Id: linestats.h 29023 2025-12-19 13:06:16Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_LINESTATS_H__
#define __GWY_LINESTATS_H__

#include <libgwyddion/line.h>

G_BEGIN_DECLS

typedef enum {
    GWY_LINE_STAT_MEAN,
    GWY_LINE_STAT_MEDIAN,
    GWY_LINE_STAT_MINIMUM,
    GWY_LINE_STAT_MAXIMUM,
    GWY_LINE_STAT_RMS,
    GWY_LINE_STAT_LENGTH,
    GWY_LINE_STAT_SLOPE,
    GWY_LINE_STAT_TAN_BETA0,
    GWY_LINE_STAT_RA,
    GWY_LINE_STAT_RZ,
    GWY_LINE_STAT_RT,
    GWY_LINE_STAT_SKEW,
    GWY_LINE_STAT_KURTOSIS,
    GWY_LINE_STAT_RANGE,
    GWY_LINE_STAT_VARIATION,
    GWY_LINE_STAT_MINPOS,
    GWY_LINE_STAT_MAXPOS,
} GwyLineStatQuantity;

gdouble gwy_line_max           (GwyLine *line);
gdouble gwy_line_min           (GwyLine *line);
void    gwy_line_min_max       (GwyLine *line,
                                gdouble *min,
                                gdouble *max);
gint    gwy_line_min_pos_i     (GwyLine *line);
gint    gwy_line_max_pos_i     (GwyLine *line);
gdouble gwy_line_min_pos_r     (GwyLine *line);
gdouble gwy_line_max_pos_r     (GwyLine *line);
gdouble gwy_line_avg           (GwyLine *line);
gdouble gwy_line_rms           (GwyLine *line);
gdouble gwy_line_tan_beta0     (GwyLine *line);
gdouble gwy_line_variation     (GwyLine *line);
gdouble gwy_line_sum           (GwyLine *line);
gdouble gwy_line_ra            (GwyLine *line);
gdouble gwy_line_skew          (GwyLine *line);
gdouble gwy_line_kurtosis      (GwyLine *line);
gdouble gwy_line_part_max      (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_min      (GwyLine *line,
                                gint pos,
                                gint len);
void    gwy_line_part_min_max  (GwyLine *line,
                                gint pos,
                                gint len,
                                gdouble *min,
                                gdouble *max);
gdouble gwy_line_part_avg      (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_rms      (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_tan_beta0(GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_variation(GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_sum      (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_ra       (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_skew     (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_part_kurtosis (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_modus         (GwyLine *line,
                                gint histogram_steps);
gdouble gwy_line_part_modus    (GwyLine *line,
                                gint pos,
                                gint len,
                                gint histogram_steps);
gdouble gwy_line_median        (GwyLine *line);
gdouble gwy_line_part_median   (GwyLine *line,
                                gint pos,
                                gint len);
gdouble gwy_line_length        (GwyLine *line);
gdouble gwy_line_xpm           (GwyLine *line,
                                gint m,
                                gint k);
gdouble gwy_line_xvm           (GwyLine *line,
                                gint m,
                                gint k);
gdouble gwy_line_xtm           (GwyLine *line,
                                gint m,
                                gint k);
gint    gwy_line_kth_peaks     (GwyLine *line,
                                gint m,
                                gint rank,
                                gboolean peaks,
                                gboolean average,
                                gdouble pthreshold,
                                gdouble vthreshold,
                                gdouble *peakvalues);
gint    gwy_line_count_peaks   (GwyLine *line,
                                gboolean peaks,
                                gdouble pthreshold,
                                gdouble vthreshold);
void    gwy_line_distribution  (GwyLine *line,
                                GwyLine *distribution,
                                gdouble ymin,
                                gdouble ymax,
                                gboolean normalize_to_unity,
                                gint nstats);
void    gwy_line_height_dist   (GwyLine *line,
                                GwyLine *target_line,
                                gdouble ymin,
                                gdouble ymax,
                                gint nsteps);
void    gwy_line_angle_dist    (GwyLine *line,
                                GwyLine *target_line,
                                gdouble ymin,
                                gdouble ymax,
                                gint nsteps);
void    gwy_line_acf           (GwyLine *line,
                                GwyLine *target_line);
void    gwy_line_hhcf          (GwyLine *line,
                                GwyLine *target_line);
void    gwy_line_psdf          (GwyLine *line,
                                GwyLine *target_line,
                                GwyWindowingType windowing);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
