#pragma once
/*
 *  $Id: selection-axis.h 28232 2025-07-16 10:46:35Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_SELECTION_AXIS_H__
#define __GWY_SELECTION_AXIS_H__

#include <libgwyddion/math.h>
#include <libgwyddion/enums.h>
#include <libgwyddion/selection.h>

G_BEGIN_DECLS

#define GWY_TYPE_SELECTION_AXIS            (gwy_selection_axis_get_type())
#define GWY_SELECTION_AXIS(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_SELECTION_AXIS, GwySelectionAxis))
#define GWY_SELECTION_AXIS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_SELECTION_AXIS, GwySelectionAxisClass))
#define GWY_IS_SELECTION_AXIS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_SELECTION_AXIS))
#define GWY_IS_SELECTION_AXIS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_SELECTION_AXIS))
#define GWY_SELECTION_AXIS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_SELECTION_AXIS, GwySelectionAxisClass))

typedef struct _GwySelectionAxis             GwySelectionAxis;
typedef struct _GwySelectionAxisClass        GwySelectionAxisClass;
typedef struct _GwySelectionAxisPrivate      GwySelectionAxisPrivate;

struct _GwySelectionAxis {
    GwySelection parent_instance;
    GwySelectionAxisPrivate *priv;
};

struct _GwySelectionAxisClass {
    GwySelectionClass parent_class;
};

GType          gwy_selection_axis_get_type       (void)                         G_GNUC_CONST;
GwySelection*  gwy_selection_axis_new            (void);
void           gwy_selection_axis_set_orientation(GwySelectionAxis *selection,
                                                  GwyOrientation orientation);
GwyOrientation gwy_selection_axis_get_orientation(GwySelectionAxis *selection);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
