#pragma once
/*
 *  $Id: selection-range.h 28232 2025-07-16 10:46:35Z yeti-dn $
 *  Copyright (C) 2006-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_SELECTION_RANGE_H__
#define __GWY_SELECTION_RANGE_H__

#include <libgwyddion/math.h>
#include <libgwyddion/enums.h>
#include <libgwyddion/selection.h>

G_BEGIN_DECLS

#define GWY_TYPE_SELECTION_RANGE            (gwy_selection_range_get_type())
#define GWY_SELECTION_RANGE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_SELECTION_RANGE, GwySelectionRange))
#define GWY_SELECTION_RANGE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_SELECTION_RANGE, GwySelectionRangeClass))
#define GWY_IS_SELECTION_RANGE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_SELECTION_RANGE))
#define GWY_IS_SELECTION_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_SELECTION_RANGE))
#define GWY_SELECTION_RANGE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_SELECTION_RANGE, GwySelectionRangeClass))

typedef struct _GwySelectionRange             GwySelectionRange;
typedef struct _GwySelectionRangeClass        GwySelectionRangeClass;
typedef struct _GwySelectionRangePrivate      GwySelectionRangePrivate;

struct _GwySelectionRange {
    GwySelection parent_instance;
    GwySelectionRangePrivate *priv;
};

struct _GwySelectionRangeClass {
    GwySelectionClass parent_class;
};

GType          gwy_selection_range_get_type       (void)                          G_GNUC_CONST;
GwySelection*  gwy_selection_range_new            (void);
void           gwy_selection_range_set_orientation(GwySelectionRange *selection,
                                                   GwyOrientation orientation);
GwyOrientation gwy_selection_range_get_orientation(GwySelectionRange *selection);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
