#pragma once
/*
 *  $Id: tip.h 28793 2025-11-05 08:18:57Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_TIP_H__
#define __GWY_TIP_H__

#include <libgwyddion/field.h>

G_BEGIN_DECLS

GwyField* gwy_tip_dilation        (GwyField *tip,
                                   GwyField *surface,
                                   GwyField *result,
                                   GwySetFractionFunc set_fraction,
                                   GwySetMessageFunc set_message);
GwyField* gwy_tip_erosion         (GwyField *tip,
                                   GwyField *surface,
                                   GwyField *result,
                                   GwySetFractionFunc set_fraction,
                                   GwySetMessageFunc set_message);
GwyField* gwy_tip_cmap            (GwyField *tip,
                                   GwyField *surface,
                                   GwyField *result,
                                   GwySetFractionFunc set_fraction,
                                   GwySetMessageFunc set_message);
GwyField* gwy_tip_estimate_partial(GwyField *tip,
                                   GwyField *surface,
                                   gdouble threshold,
                                   gboolean use_edges,
                                   gint *count,
                                   GwySetFractionFunc set_fraction,
                                   GwySetMessageFunc set_message);
GwyField* gwy_tip_estimate_full   (GwyField *tip,
                                   GwyField *surface,
                                   gdouble threshold,
                                   gboolean use_edges,
                                   gint *count,
                                   GwySetFractionFunc set_fraction,
                                   GwySetMessageFunc set_message);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
