#pragma once
/*
 *  $Id: xy.h 28915 2025-11-26 17:25:41Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_XY_H__
#define __GWY_XY_H__

#include <math.h>
#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

typedef struct {
    gdouble x;
    gdouble y;
} GwyXY;

#define GWY_TYPE_XY (gwy_xy_get_type())

GType   gwy_xy_get_type  (void)                G_GNUC_CONST;
GwyXY*  gwy_xy_new       (gdouble x,
                          gdouble y)           G_GNUC_MALLOC;
GwyXY*  gwy_xy_copy      (const GwyXY *xy)     G_GNUC_MALLOC;
void    gwy_xy_free      (GwyXY *xy);
gdouble gwy_xy_len       (const GwyXY *xy);
gdouble gwy_xy_len2      (const GwyXY *xy);
gdouble gwy_xy_dotprod   (const GwyXY *xy,
                          const GwyXY *other);
gdouble gwy_xy_crossprodz(const GwyXY *xy,
                          const GwyXY *other);

/* See math.h for an extensive discussion of the inline function definition scheme. */
#ifndef __GI_SCANNER__
#define gwy_xy_len        _gwy_xy_len_implementation
#define gwy_xy_len2       _gwy_xy_len2_implementation
#define gwy_xy_dotprod    _gwy_xy_dotprod_implementation
#define gwy_xy_crossprodz _gwy_xy_crossprodz_implementation

G_GNUC_UNUSED
static inline gdouble
_gwy_xy_len_implementation(const GwyXY *xy)
{
    return /**/ sqrt(xy->x*xy->x + xy->y*xy->y);
}

G_GNUC_UNUSED
static inline gdouble
_gwy_xy_len2_implementation(const GwyXY *xy)
{
    return /**/ xy->x*xy->x + xy->y*xy->y;
}

G_GNUC_UNUSED
static inline gdouble
_gwy_xy_dotprod_implementation(const GwyXY *xy, const GwyXY *other)
{
    return /**/ xy->x*other->x + xy->y*other->y;
}

G_GNUC_UNUSED
static inline gdouble
_gwy_xy_crossprodz_implementation(const GwyXY *xy, const GwyXY *other)
{
    return /**/ xy->x*other->y - xy->y*other->x;
}

#endif

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
