/*
 *  $Id: graph-corner.c 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include <gtk/gtk.h>

#include "libgwyddion/macros.h"

#include "libgwyui/graph-corner.h"

struct _GwyGraphCornerPrivate {
    gint dummy;
};

static gboolean draw(GtkWidget *widget,
                     cairo_t *cr);

/* Do not actually add any private until we need it. */
G_DEFINE_TYPE(GwyGraphCorner, gwy_graph_corner, GTK_TYPE_WIDGET)

static void
gwy_graph_corner_class_init(GwyGraphCornerClass *klass)
{
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(klass);

    widget_class->draw = draw;
}

static void
gwy_graph_corner_init(GwyGraphCorner *graph_corner)
{
    gtk_widget_set_has_window(GTK_WIDGET(graph_corner), FALSE);
}

/**
 * gwy_graph_corner_new:
 *
 * Creates a new graph corner.
 *
 * Returns: A new graph corner as a #GtkWidget.
 **/
GtkWidget*
gwy_graph_corner_new(void)
{
    return gtk_widget_new(GWY_TYPE_GRAPH_CORNER, NULL);
}

static gboolean
draw(G_GNUC_UNUSED GtkWidget *widget, cairo_t *cr)
{
    cairo_set_source_rgb(cr, 1.0, 1.0, 1.0);
    cairo_paint(cr);

    return FALSE;
}

/**
 * SECTION: graph-corner
 * @title: GwyGraphCorner
 * @short_description: Graph corners
 *
 * #GwyGraphCorner is a part of #GwyGraph and it currently has no functionality.  It is reserved for future.  It might
 * be used for some graph options quick accesibility.
 **/

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
