#pragma once
/*
 *  $Id: graph-curve-dialog.h 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_CURVE_DIALOG_H__
#define __GWYUI_GRAPH_CURVE_DIALOG_H__

#include <gtk/gtk.h>
#include <libgwyui/gwygraphcurvemodel.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRAPH_CURVE_DIALOG            (gwy_graph_curve_dialog_get_type())
#define GWY_GRAPH_CURVE_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_CURVE_DIALOG, GwyGraphCurveDialog))
#define GWY_GRAPH_CURVE_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_CURVE_DIALOG, GwyGraphCurveDialogClass))
#define GWY_IS_GRAPH_CURVE_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_CURVE_DIALOG))
#define GWY_IS_GRAPH_CURVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_CURVE_DIALOG))
#define GWY_GRAPH_CURVE_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_CURVE_DIALOG, GwyGraphCurveDialogClass))

typedef struct _GwyGraphCurveDialog             GwyGraphCurveDialog;
typedef struct _GwyGraphCurveDialogClass        GwyGraphCurveDialogClass;
typedef struct _GwyGraphCurveDialogPrivate      GwyGraphCurveDialogPrivate;

struct _GwyGraphCurveDialog {
    GtkDialog parent_instance;
    GwyGraphCurveDialogPrivate *priv;
};

struct _GwyGraphCurveDialogClass {
    GtkDialogClass parent_class;

    void (*next)(GwyGraphCurveDialog *dialog);
    void (*previous)(GwyGraphCurveDialog *dialog);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType               gwy_graph_curve_dialog_get_type      (void)                         G_GNUC_CONST;
GtkWidget*          gwy_graph_curve_dialog_new           (void);
GtkWidget*          gwy_graph_curve_dialog_new_with_model(GwyGraphCurveModel *cmodel);
GwyGraphCurveModel* gwy_graph_curve_dialog_get_model     (GwyGraphCurveDialog *dialog);
void                gwy_graph_curve_dialog_set_model     (GwyGraphCurveDialog *dialog,
                                                          GwyGraphCurveModel *cmodel);
void                gwy_graph_curve_dialog_set_switching (GwyGraphCurveDialog *dialog,
                                                          gboolean prev_possible,
                                                          gboolean next_possible);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
