#pragma once
/*
 *  $Id: graph-key-dialog.h 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*< private_header >*/

#ifndef __GWYUI_GRAPH_KEY_DIALOG_H__
#define __GWYUI_GRAPH_KEY_DIALOG_H__

#include <gtk/gtk.h>
#include <libgwyui/gwygraphmodel.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRAPH_KEY_DIALOG            (_gwy_graph_key_dialog_get_type())
#define GWY_GRAPH_KEY_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_KEY_DIALOG, GwyGraphKeyDialog))
#define GWY_GRAPH_KEY_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_KEY_DIALOG, GwyGraphKeyDialogClass))
#define GWY_IS_GRAPH_KEY_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_KEY_DIALOG))
#define GWY_IS_GRAPH_KEY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_KEY_DIALOG))
#define GWY_GRAPH_KEY_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_KEY_DIALOG, GwyGraphKeyDialogClass))

typedef struct _GwyGraphKeyDialog      GwyGraphKeyDialog;
typedef struct _GwyGraphKeyDialogClass GwyGraphKeyDialogClass;

struct _GwyGraphKeyDialog {
    GtkDialog dialog;
    GwyGraphModel *graph_model;
    glong notify_id;
    GtkAdjustment *thickness;
    GtkWidget *reversed;
    gboolean updating;
};

struct _GwyGraphKeyDialogClass {
    GtkDialogClass parent_class;
};

G_GNUC_INTERNAL GType      _gwy_graph_key_dialog_get_type (void)                      G_GNUC_CONST;
G_GNUC_INTERNAL GtkWidget* _gwy_graph_key_dialog_new      (void);
G_GNUC_INTERNAL void       _gwy_graph_key_dialog_set_model(GwyGraphKeyDialog *dialog,
                                                           GwyGraphModel *model);

G_END_DECLS

#endif

/* vim: set cin et columns=120 tw=118 ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
