#pragma once
/*
 *  $Id: gwydataview.h 28778 2025-11-04 16:47:31Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_DATA_VIEW_H__
#define __GWYUI_DATA_VIEW_H__

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>

#include <libgwyddion/rgba.h>
#include <libgwyddion/field.h>
#include <libgwyddion/gradient.h>
#include <libgwyui/gwyvectorlayer.h>
#include <libgwyui/pixbuf-render.h>

G_BEGIN_DECLS

#define GWY_TYPE_DATA_VIEW            (gwy_data_view_get_type())
#define GWY_DATA_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_DATA_VIEW, GwyDataView))
#define GWY_DATA_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_DATA_VIEW, GwyDataViewClass))
#define GWY_IS_DATA_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_DATA_VIEW))
#define GWY_IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_DATA_VIEW))
#define GWY_DATA_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_DATA_VIEW, GwyDataViewClass))

typedef struct _GwyDataView             GwyDataView;
typedef struct _GwyDataViewClass        GwyDataViewClass;
typedef struct _GwyDataViewPrivate      GwyDataViewPrivate;
typedef struct _GwyDataViewClassPrivate GwyDataViewClassPrivate;

struct _GwyDataView {
    GtkWidget widget;
    GwyDataViewPrivate *priv;
};

struct _GwyDataViewClass {
    GtkWidgetClass parent_class;

    /* Signals */
    void (*redrawn)(GwyDataView *view);
    void (*resized)(GwyDataView *view);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
    void (*reserved5)(void);
};

GType               gwy_data_view_get_type               (void)                         G_GNUC_CONST;
GtkWidget*          gwy_data_view_new                    (void);
GwyField*           gwy_data_view_get_field              (GwyDataView *view);
void                gwy_data_view_set_field              (GwyDataView *view,
                                                          GwyField *field);
GwyField*           gwy_data_view_get_mask               (GwyDataView *view);
void                gwy_data_view_set_mask               (GwyDataView *view,
                                                          GwyField *mask);
GwyVectorLayer*     gwy_data_view_get_interactive_layer  (GwyDataView *view);
void                gwy_data_view_set_interactive_layer  (GwyDataView *view,
                                                          GwyVectorLayer *layer);
gboolean            gwy_data_view_get_real_square        (GwyDataView *view);
void                gwy_data_view_set_real_square        (GwyDataView *view,
                                                          gboolean real_square);
void                gwy_data_view_get_color_range        (GwyDataView *view,
                                                          gdouble *min,
                                                          gdouble *max);
gboolean            gwy_data_view_get_fixed_color_range  (GwyDataView *view,
                                                          gdouble *min,
                                                          gdouble *max);
void                gwy_data_view_set_fixed_color_range  (GwyDataView *view,
                                                          gdouble min,
                                                          gdouble max);
void                gwy_data_view_unset_fixed_color_range(GwyDataView *view);
GwyColorMappingType gwy_data_view_get_color_mapping      (GwyDataView *view);
void                gwy_data_view_set_color_mapping      (GwyDataView *view,
                                                          GwyColorMappingType mapping);
GwyGradient*        gwy_data_view_get_gradient           (GwyDataView *view);
void                gwy_data_view_set_gradient           (GwyDataView *view,
                                                          GwyGradient *gradient);
void                gwy_data_view_get_mask_color         (GwyDataView *view,
                                                          GwyRGBA *color);
void                gwy_data_view_set_mask_color         (GwyDataView *view,
                                                          const GwyRGBA *color);
gdouble             gwy_data_view_get_hexcess            (GwyDataView* view);
gdouble             gwy_data_view_get_vexcess            (GwyDataView* view);
gdouble             gwy_data_view_get_zoom               (GwyDataView *view);
void                gwy_data_view_set_zoom               (GwyDataView *view,
                                                          gdouble zoom);
gdouble             gwy_data_view_get_real_zoom          (GwyDataView *view);
gboolean            gwy_data_view_coords_widget_clamp    (GwyDataView *view,
                                                          gdouble *xscr,
                                                          gdouble *yscr);
gboolean            gwy_data_view_coords_widget_cut_line (GwyDataView *view,
                                                          gdouble *x0scr,
                                                          gdouble *y0scr,
                                                          gdouble *x1scr,
                                                          gdouble *y1scr);
void                gwy_data_view_coords_widget_to_real  (GwyDataView *view,
                                                          gdouble xscr,
                                                          gdouble yscr,
                                                          gdouble *xreal,
                                                          gdouble *yreal);
void                gwy_data_view_coords_real_to_widget  (GwyDataView *view,
                                                          gdouble xreal,
                                                          gdouble yreal,
                                                          gdouble *xscr,
                                                          gdouble *yscr);
gdouble             gwy_data_view_get_xmeasure           (GwyDataView *view);
gdouble             gwy_data_view_get_ymeasure           (GwyDataView *view);
gdouble             gwy_data_view_get_xzoom              (GwyDataView *view);
gdouble             gwy_data_view_get_yzoom              (GwyDataView *view);
void                gwy_data_view_set_resizable          (GwyDataView *view,
                                                          gboolean resizable);
/* FIXME GTK3 Remove. It is easy enough to get the underlying field now. */
void       gwy_data_view_get_pixel_data_sizes(GwyDataView *view,
                                              gint *xres,
                                              gint *yres);
void       gwy_data_view_get_real_data_sizes (GwyDataView *view,
                                              gdouble *xreal,
                                              gdouble *yreal);
void       gwy_data_view_get_metric          (GwyDataView *view,
                                              gdouble *metric);
GdkPixbuf* gwy_data_view_get_pixbuf          (GwyDataView *view,
                                              gint max_width,
                                              gint max_height);
void       gwy_data_view_set_named_cursor    (GwyDataView *view,
                                              const gchar *name);


G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
