#pragma once
/*
 *  $Id: gwygllabel.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2005-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GL_LABEL_H__
#define __GWYUI_GL_LABEL_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define GWY_TYPE_GL_LABEL            (gwy_gl_label_get_type())
#define GWY_GL_LABEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GL_LABEL, GwyGLLabel))
#define GWY_GL_LABEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GL_LABEL, GwyGLLabelClass))
#define GWY_IS_GL_LABEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GL_LABEL))
#define GWY_IS_GL_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GL_LABEL))
#define GWY_GL_LABEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GL_LABEL, GwyGLLabelClass))

typedef struct _GwyGLLabel             GwyGLLabel;
typedef struct _GwyGLLabelClass        GwyGLLabelClass;
typedef struct _GwyGLLabelPrivate      GwyGLLabelPrivate;

struct _GwyGLLabel {
    GObject parent_instance;
    GwyGLLabelPrivate *priv;
};

struct _GwyGLLabelClass {
    GObjectClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType        gwy_gl_label_get_type      (void)                       G_GNUC_CONST;
GwyGLLabel*  gwy_gl_label_new           (const gchar *default_text);
void         gwy_gl_label_set_text      (GwyGLLabel *label,
                                         const gchar *text);
const gchar* gwy_gl_label_get_text      (GwyGLLabel *label);
gchar*       gwy_gl_label_expand_text   (GwyGLLabel *label,
                                         GHashTable *variables);
void         gwy_gl_label_reset         (GwyGLLabel *label);
void         gwy_gl_label_reset_text    (GwyGLLabel *label);
gdouble      gwy_gl_label_user_size     (GwyGLLabel *label,
                                         gdouble user_size);
gdouble      gwy_gl_label_get_delta_x   (GwyGLLabel *label);
gdouble      gwy_gl_label_get_delta_y   (GwyGLLabel *label);
gdouble      gwy_gl_label_get_rotation  (GwyGLLabel *label);
gdouble      gwy_gl_label_get_size      (GwyGLLabel *label);
gboolean     gwy_gl_label_get_fixed_size(GwyGLLabel *label);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
