#pragma once
/*
 *  $Id: gwyglwindow.h 28778 2025-11-04 16:47:31Z yeti-dn $
 *  Copyright (C) 2004-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GL_WINDOW_H__
#define __GWYUI_GL_WINDOW_H__

#include <gdk/gdkwindow.h>
#include <gtk/gtk.h>
#include <libgwyui/gwyglview.h>

G_BEGIN_DECLS

#define GWY_TYPE_GL_WINDOW            (gwy_gl_window_get_type())
#define GWY_GL_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GL_WINDOW, GwyGLWindow))
#define GWY_GL_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GL_WINDOW, GwyGLWindowClass))
#define GWY_IS_GL_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GL_WINDOW))
#define GWY_IS_GL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GL_WINDOW))
#define GWY_GL_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GL_WINDOW, GwyGLWindowClass))

typedef struct _GwyGLWindow             GwyGLWindow;
typedef struct _GwyGLWindowClass        GwyGLWindowClass;
typedef struct _GwyGLWindowPrivate      GwyGLWindowPrivate;

struct _GwyGLWindow {
    GtkWindow parent_instance;
    GwyGLWindowPrivate *priv;
};

struct _GwyGLWindowClass {
    GtkWindowClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType      gwy_gl_window_get_type                (void)                   G_GNUC_CONST;
GtkWidget* gwy_gl_window_new                     (GwyContainer *data);
GtkWidget* gwy_gl_window_get_gl_view             (GwyGLWindow *window);
void       gwy_gl_window_add_action_widget       (GwyGLWindow *window,
                                                  GtkWidget *widget);
void       gwy_gl_window_add_small_toolbar_button(GwyGLWindow *window,
                                                  const gchar *icon_name,
                                                  const gchar *tooltip,
                                                  GCallback callback,
                                                  gpointer cbdata);
void       gwy_gl_window_set_overlay_chooser     (GwyGLWindow *window,
                                                  GtkWidget *chooser);
GtkWidget* gwy_gl_window_get_overlay_chooser     (GwyGLWindow *window);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
