/*
 *  $Id: icons.c 27952 2025-05-09 16:41:38Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "libgwyui/icons.h"

/**
 * SECTION:gwystock
 * @title: gwystock
 * @short_description: Named icons
 **/

/* The following generated part is updated by running utils/stockgen.py */

/* @@@ GENERATED ICON LIST BEGIN @@@ */
/**
 * GWY_ICON_3D_BASE:
 *
 * The "Gwy-3D-Base" icon.
 * <inlinegraphic fileref="gwy_gwy_3d_base-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ARITHMETIC:
 *
 * The "Gwy-Arithmetic" icon.
 * <inlinegraphic fileref="gwy_gwy_arithmetic-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_BINNING:
 *
 * The "Gwy-Binning" icon.
 * <inlinegraphic fileref="gwy_gwy_binning-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_BOLD:
 *
 * The "Gwy-Bold" icon.
 * <inlinegraphic fileref="gwy_gwy_bold-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CANTILEVER:
 *
 * The "Gwy-Cantilever" icon.
 * <inlinegraphic fileref="gwy_gwy_cantilever-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE:
 *
 * The "Gwy-Color-Range" icon.
 * <inlinegraphic fileref="gwy_gwy_color_range-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_ADAPTIVE:
 *
 * The "Gwy-Color-Range-Adaptive" icon.
 * <inlinegraphic fileref="gwy_gwy_color_range_adaptive-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_AUTO:
 *
 * The "Gwy-Color-Range-Auto" icon.
 * <inlinegraphic fileref="gwy_gwy_color_range_auto-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_FIXED:
 *
 * The "Gwy-Color-Range-Fixed" icon.
 * <inlinegraphic fileref="gwy_gwy_color_range_fixed-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_FULL:
 *
 * The "Gwy-Color-Range-Full" icon.
 * <inlinegraphic fileref="gwy_gwy_color_range_full-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CONVOLUTION:
 *
 * The "Gwy-Convolution" icon.
 * <inlinegraphic fileref="gwy_gwy_convolution-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CONVOLVE:
 *
 * The "Gwy-Convolve" icon.
 * <inlinegraphic fileref="gwy_gwy_convolve-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CORRECT_AFFINE:
 *
 * The "Gwy-Correct-Affine" icon.
 * <inlinegraphic fileref="gwy_gwy_correct_affine-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CORRELATION_LENGTH:
 *
 * The "Gwy-Correlation-Length" icon.
 * <inlinegraphic fileref="gwy_gwy_correlation_length-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CORRELATION_MASK:
 *
 * The "Gwy-Correlation-Mask" icon.
 * <inlinegraphic fileref="gwy_gwy_correlation_mask-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CROP:
 *
 * The "Gwy-Crop" icon.
 * <inlinegraphic fileref="gwy_gwy_crop-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CROSS_PROFILE:
 *
 * The "Gwy-Cross-Profile" icon.
 * <inlinegraphic fileref="gwy_gwy_cross_profile-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CURVATURE:
 *
 * The "Gwy-Curvature" icon.
 * <inlinegraphic fileref="gwy_gwy_curvature-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_CWT:
 *
 * The "Gwy-CWT" icon.
 * <inlinegraphic fileref="gwy_gwy_cwt-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DATA_MEASURE:
 *
 * The "Gwy-Data-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_data_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DECONVOLVE:
 *
 * The "Gwy-Deconvolve" icon.
 * <inlinegraphic fileref="gwy_gwy_deconvolve-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DISCONNECTED:
 *
 * The "Gwy-Disconnected" icon.
 * <inlinegraphic fileref="gwy_gwy_disconnected-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DISPLACEMENT_FIELD:
 *
 * The "Gwy-Displacement-Field" icon.
 * <inlinegraphic fileref="gwy_gwy_displacement_field-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DISTANCE:
 *
 * The "Gwy-Distance" icon.
 * <inlinegraphic fileref="gwy_gwy_distance-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DISTANCE_TRANSFORM:
 *
 * The "Gwy-Distance-Transform" icon.
 * <inlinegraphic fileref="gwy_gwy_distance_transform-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DISTRIBUTION_ANGLE:
 *
 * The "Gwy-Distribution-Angle" icon.
 * <inlinegraphic fileref="gwy_gwy_distribution_angle-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DISTRIBUTION_SLOPE:
 *
 * The "Gwy-Distribution-Slope" icon.
 * <inlinegraphic fileref="gwy_gwy_distribution_slope-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DRIFT:
 *
 * The "Gwy-Drift" icon.
 * <inlinegraphic fileref="gwy_gwy_drift-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_DWT:
 *
 * The "Gwy-DWT" icon.
 * <inlinegraphic fileref="gwy_gwy_dwt-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_EDGE:
 *
 * The "Gwy-Edge" icon.
 * <inlinegraphic fileref="gwy_gwy_edge-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ENFORCE_DISTRIBUTION:
 *
 * The "Gwy-Enforce-Distribution" icon.
 * <inlinegraphic fileref="gwy_gwy_enforce_distribution-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ENTROPY:
 *
 * The "Gwy-Entropy" icon.
 * <inlinegraphic fileref="gwy_gwy_entropy-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_EXTEND:
 *
 * The "Gwy-Extend" icon.
 * <inlinegraphic fileref="gwy_gwy_extend-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_EXTRACT_PATH:
 *
 * The "Gwy-Extract-Path" icon.
 * <inlinegraphic fileref="gwy_gwy_extract_path-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FACET_ANALYSIS:
 *
 * The "Gwy-Facet-Analysis" icon.
 * <inlinegraphic fileref="gwy_gwy_facet_analysis-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FACET_LEVEL:
 *
 * The "Gwy-Facet-Level" icon.
 * <inlinegraphic fileref="gwy_gwy_facet_level-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FACET_MEASURE:
 *
 * The "Gwy-Facet-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_facet_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FAVOURITE:
 *
 * The "Gwy-Favourite" icon.
 * <inlinegraphic fileref="gwy_gwy_favourite-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FFT:
 *
 * The "Gwy-FFT" icon.
 * <inlinegraphic fileref="gwy_gwy_fft-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FFT_2D:
 *
 * The "Gwy-FFT-2D" icon.
 * <inlinegraphic fileref="gwy_gwy_fft_2d-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FFT_FILTER_1D:
 *
 * The "Gwy-FFT-Filter-1D" icon.
 * <inlinegraphic fileref="gwy_gwy_fft_filter_1d-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FFT_FILTER_2D:
 *
 * The "Gwy-FFT-Filter-2D" icon.
 * <inlinegraphic fileref="gwy_gwy_fft_filter_2d-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FILTER:
 *
 * The "Gwy-Filter" icon.
 * <inlinegraphic fileref="gwy_gwy_filter-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FIND_PEAKS:
 *
 * The "Gwy-Find-Peaks" icon.
 * <inlinegraphic fileref="gwy_gwy_find_peaks-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FIT_SHAPE:
 *
 * The "Gwy-Fit-Shape" icon.
 * <inlinegraphic fileref="gwy_gwy_fit_shape-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FIX_ZERO:
 *
 * The "Gwy-Fix-Zero" icon.
 * <inlinegraphic fileref="gwy_gwy_fix_zero-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FLIP_DIAGONALLY:
 *
 * The "Gwy-Flip-Diagonally" icon.
 * <inlinegraphic fileref="gwy_gwy_flip_diagonally-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FLIP_HORIZONTALLY:
 *
 * The "Gwy-Flip-Horizontally" icon.
 * <inlinegraphic fileref="gwy_gwy_flip_horizontally-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FLIP_VERTICALLY:
 *
 * The "Gwy-Flip-Vertically" icon.
 * <inlinegraphic fileref="gwy_gwy_flip_vertically-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FRACTAL:
 *
 * The "Gwy-Fractal" icon.
 * <inlinegraphic fileref="gwy_gwy_fractal-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FRACTAL_CORRECTION:
 *
 * The "Gwy-Fractal-Correction" icon.
 * <inlinegraphic fileref="gwy_gwy_fractal_correction-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FRACTAL_MEASURE:
 *
 * The "Gwy-Fractal-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_fractal_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_FREQUENCY_SPLIT:
 *
 * The "Gwy-Frequency-Split" icon.
 * <inlinegraphic fileref="gwy_gwy_frequency_split-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GL_MATERIAL:
 *
 * The "Gwy-GL-Material" icon.
 * <inlinegraphic fileref="gwy_gwy_gl_material-16.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRADIENT_HORIZONTAL:
 *
 * The "Gwy-Gradient-Horizontal" icon.
 * <inlinegraphic fileref="gwy_gwy_gradient_horizontal-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRADIENT_VERTICAL:
 *
 * The "Gwy-Gradient-Vertical" icon.
 * <inlinegraphic fileref="gwy_gwy_gradient_vertical-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAIN_BOUNDING_BOX:
 *
 * The "Gwy-Grain-Bounding-Box" icon.
 * <inlinegraphic fileref="gwy_gwy_grain_bounding_box-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAIN_CORRELATION:
 *
 * The "Gwy-Grain-Correlation" icon.
 * <inlinegraphic fileref="gwy_gwy_grain_correlation-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAIN_EXSCRIBED_CIRCLE:
 *
 * The "Gwy-Grain-Exscribed-Circle" icon.
 * <inlinegraphic fileref="gwy_gwy_grain_exscribed_circle-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAIN_INSCRIBED_BOX:
 *
 * The "Gwy-Grain-Inscribed-Box" icon.
 * <inlinegraphic fileref="gwy_gwy_grain_inscribed_box-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAIN_INSCRIBED_CIRCLE:
 *
 * The "Gwy-Grain-Inscribed-Circle" icon.
 * <inlinegraphic fileref="gwy_gwy_grain_inscribed_circle-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS:
 *
 * The "Gwy-Grains" icon.
 * <inlinegraphic fileref="gwy_gwy_grains-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_EDGE:
 *
 * The "Gwy-Grains-Edge" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_edge-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_EDGE_REMOVE:
 *
 * The "Gwy-Grains-Edge-Remove" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_edge_remove-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_GRAPH:
 *
 * The "Gwy-Grains-Graph" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_graph-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_MEASURE:
 *
 * The "Gwy-Grains-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_OTSU:
 *
 * The "Gwy-Grains-Otsu" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_otsu-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_REMOVE:
 *
 * The "Gwy-Grains-Remove" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_remove-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_STATISTICS:
 *
 * The "Gwy-Grains-Statistics" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_statistics-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAINS_WATER:
 *
 * The "Gwy-Grains-Water" icon.
 * <inlinegraphic fileref="gwy_gwy_grains_water-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH:
 *
 * The "Gwy-Graph" icon.
 * <inlinegraphic fileref="gwy_gwy_graph-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_ALIGN:
 *
 * The "Gwy-Graph-Align" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_align-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_CUT:
 *
 * The "Gwy-Graph-Cut" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_cut-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_DOS:
 *
 * The "Gwy-Graph-Dos" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_dos-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_EXPORT_ASCII:
 *
 * The "Gwy-Graph-Export-Ascii" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_export_ascii-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_EXPORT_PNG:
 *
 * The "Gwy-Graph-Export-PNG" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_export_png-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_EXPORT_VECTOR:
 *
 * The "Gwy-Graph-Export-Vector" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_export_vector-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_FD:
 *
 * The "Gwy-Graph-FD" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_fd-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_FILTER:
 *
 * The "Gwy-Graph-Filter" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_filter-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_FUNCTION:
 *
 * The "Gwy-Graph-Function" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_function-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_HALFGAUSS:
 *
 * The "Gwy-Graph-Halfgauss" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_halfgauss-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_LEVEL:
 *
 * The "Gwy-Graph-Level" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_level-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_MEASURE:
 *
 * The "Gwy-Graph-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_PALETTE:
 *
 * The "Gwy-Graph-Palette" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_palette-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_PERIOD_MEASURE:
 *
 * The "Gwy-Graph-Period-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_period_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_POINTER:
 *
 * The "Gwy-Graph-Pointer" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_pointer-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_RULER:
 *
 * The "Gwy-Graph-Ruler" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_ruler-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_STATISTICS:
 *
 * The "Gwy-Graph-Statistics" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_statistics-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_TERRACE_MEASURE:
 *
 * The "Gwy-Graph-Terrace-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_terrace_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_VERTICAL:
 *
 * The "Gwy-Graph-Vertical" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_vertical-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_ZOOM_FIT:
 *
 * The "Gwy-Graph-Zoom-Fit" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_zoom_fit-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_ZOOM_IN:
 *
 * The "Gwy-Graph-Zoom-In" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_zoom_in-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GRAPH_ZOOM_OUT:
 *
 * The "Gwy-Graph-Zoom-Out" icon.
 * <inlinegraphic fileref="gwy_gwy_graph_zoom_out-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_HOLD_SELECTION_CLEAR:
 *
 * The "Gwy-Hold-Selection-Clear" icon.
 * <inlinegraphic fileref="gwy_gwy_hold_selection_clear-18.png" format="PNG"/>
 **/

/**
 * GWY_ICON_HOLD_SELECTION_REPLACE:
 *
 * The "Gwy-Hold-Selection-Replace" icon.
 * <inlinegraphic fileref="gwy_gwy_hold_selection_replace-18.png" format="PNG"/>
 **/

/**
 * GWY_ICON_HOUGH:
 *
 * The "Gwy-Hough" icon.
 * <inlinegraphic fileref="gwy_gwy_hough-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_IMAGE_RELATION:
 *
 * The "Gwy-Image-Relation" icon.
 * <inlinegraphic fileref="gwy_gwy_image_relation-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_IMMERSE:
 *
 * The "Gwy-Immerse" icon.
 * <inlinegraphic fileref="gwy_gwy_immerse-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ISO_ROUGHNESS:
 *
 * The "Gwy-Iso-Roughness" icon.
 * <inlinegraphic fileref="gwy_gwy_iso_roughness-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ITALIC:
 *
 * The "Gwy-Italic" icon.
 * <inlinegraphic fileref="gwy_gwy_italic-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LESS:
 *
 * The "Gwy-Less" icon.
 * <inlinegraphic fileref="gwy_gwy_less-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LEVEL:
 *
 * The "Gwy-Level" icon.
 * <inlinegraphic fileref="gwy_gwy_level-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LEVEL_FLATTEN_BASE:
 *
 * The "Gwy-Level-Flatten-Base" icon.
 * <inlinegraphic fileref="gwy_gwy_level_flatten_base-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LEVEL_MEDIAN:
 *
 * The "Gwy-Level-Median" icon.
 * <inlinegraphic fileref="gwy_gwy_level_median-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LEVEL_TRIANGLE:
 *
 * The "Gwy-Level-Triangle" icon.
 * <inlinegraphic fileref="gwy_gwy_level_triangle-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LIGHT_ROTATE:
 *
 * The "Gwy-Light-Rotate" icon.
 * <inlinegraphic fileref="gwy_gwy_light_rotate-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LIMIT_RANGE:
 *
 * The "Gwy-Limit-Range" icon.
 * <inlinegraphic fileref="gwy_gwy_limit_range-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LINE_LEVEL:
 *
 * The "Gwy-Line-Level" icon.
 * <inlinegraphic fileref="gwy_gwy_line_level-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LOAD_DEBUG:
 *
 * The "Gwy-Load-Debug" icon.
 * <inlinegraphic fileref="gwy_gwy_load_debug-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LOAD_INFO:
 *
 * The "Gwy-Load-Info" icon.
 * <inlinegraphic fileref="gwy_gwy_load_info-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LOAD_WARNING:
 *
 * The "Gwy-Load-Warning" icon.
 * <inlinegraphic fileref="gwy_gwy_load_warning-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LOCAL_SLOPE:
 *
 * The "Gwy-Local-Slope" icon.
 * <inlinegraphic fileref="gwy_gwy_local_slope-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LOGSCALE_HORIZONTAL:
 *
 * The "Gwy-Logscale-Horizontal" icon.
 * <inlinegraphic fileref="gwy_gwy_logscale_horizontal-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_LOGSCALE_VERTICAL:
 *
 * The "Gwy-Logscale-Vertical" icon.
 * <inlinegraphic fileref="gwy_gwy_logscale_vertical-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MARK_OUTLIERS:
 *
 * The "Gwy-Mark-Outliers" icon.
 * <inlinegraphic fileref="gwy_gwy_mark_outliers-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MARK_SCARS:
 *
 * The "Gwy-Mark-Scars" icon.
 * <inlinegraphic fileref="gwy_gwy_mark_scars-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MARK_WITH:
 *
 * The "Gwy-Mark-With" icon.
 * <inlinegraphic fileref="gwy_gwy_mark_with-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK:
 *
 * The "Gwy-Mask" icon.
 * <inlinegraphic fileref="gwy_gwy_mask-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_ADD:
 *
 * The "Gwy-Mask-Add" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_add-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_CIRCLE:
 *
 * The "Gwy-Mask-Circle" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_circle-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_CIRCLE_EXCLUSIVE:
 *
 * The "Gwy-Mask-Circle-Exclusive" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_circle_exclusive-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_CIRCLE_INCLUSIVE:
 *
 * The "Gwy-Mask-Circle-Inclusive" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_circle_inclusive-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_DISTRIBUTE:
 *
 * The "Gwy-Mask-Distribute" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_distribute-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_EDITOR:
 *
 * The "Gwy-Mask-Editor" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_editor-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_EXCLUDE:
 *
 * The "Gwy-Mask-Exclude" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_exclude-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_EXCLUDE_CIRCLE:
 *
 * The "Gwy-Mask-Exclude-Circle" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_exclude_circle-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_EXTRACT:
 *
 * The "Gwy-Mask-Extract" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_extract-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_FILL_DRAW:
 *
 * The "Gwy-Mask-Fill-Draw" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_fill_draw-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_FILL_ERASE:
 *
 * The "Gwy-Mask-Fill-Erase" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_fill_erase-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_GROW:
 *
 * The "Gwy-Mask-Grow" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_grow-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_INTERSECT:
 *
 * The "Gwy-Mask-Intersect" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_intersect-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_INVERT:
 *
 * The "Gwy-Mask-Invert" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_invert-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_LINE:
 *
 * The "Gwy-Mask-Line" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_line-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_MORPH:
 *
 * The "Gwy-Mask-Morph" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_morph-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_NOISIFY:
 *
 * The "Gwy-Mask-Noisify" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_noisify-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_PAINT_DRAW:
 *
 * The "Gwy-Mask-Paint-Draw" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_paint_draw-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_PAINT_ERASE:
 *
 * The "Gwy-Mask-Paint-Erase" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_paint_erase-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_RECT_EXCLUSIVE:
 *
 * The "Gwy-Mask-Rect-Exclusive" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_rect_exclusive-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_RECT_INCLUSIVE:
 *
 * The "Gwy-Mask-Rect-Inclusive" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_rect_inclusive-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_REMOVE:
 *
 * The "Gwy-Mask-Remove" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_remove-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_SET:
 *
 * The "Gwy-Mask-Set" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_set-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_SHIFT:
 *
 * The "Gwy-Mask-Shift" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_shift-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_SHRINK:
 *
 * The "Gwy-Mask-Shrink" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_shrink-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_SUBTRACT:
 *
 * The "Gwy-Mask-Subtract" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_subtract-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MASK_THIN:
 *
 * The "Gwy-Mask-Thin" icon.
 * <inlinegraphic fileref="gwy_gwy_mask_thin-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MEASURE_LATTICE:
 *
 * The "Gwy-Measure-Lattice" icon.
 * <inlinegraphic fileref="gwy_gwy_measure_lattice-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MERGE:
 *
 * The "Gwy-Merge" icon.
 * <inlinegraphic fileref="gwy_gwy_merge-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MFM_CONVERT_TO_FORCE:
 *
 * The "Gwy-MFM-Convert-To-Force" icon.
 * <inlinegraphic fileref="gwy_gwy_mfm_convert_to_force-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MFM_CURRENT_LINE:
 *
 * The "Gwy-MFM-Current-Line" icon.
 * <inlinegraphic fileref="gwy_gwy_mfm_current_line-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MFM_FIELD_FIND_SHIFT:
 *
 * The "Gwy-MFM-Field-Find-Shift" icon.
 * <inlinegraphic fileref="gwy_gwy_mfm_field_find_shift-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MFM_FIELD_SHIFT:
 *
 * The "Gwy-MFM-Field-Shift" icon.
 * <inlinegraphic fileref="gwy_gwy_mfm_field_shift-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MFM_PARALLEL:
 *
 * The "Gwy-MFM-Parallel" icon.
 * <inlinegraphic fileref="gwy_gwy_mfm_parallel-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MFM_PERPENDICULAR:
 *
 * The "Gwy-MFM-Perpendicular" icon.
 * <inlinegraphic fileref="gwy_gwy_mfm_perpendicular-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MORE:
 *
 * The "Gwy-More" icon.
 * <inlinegraphic fileref="gwy_gwy_more-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_MUTUAL_CROP:
 *
 * The "Gwy-Mutual-Crop" icon.
 * <inlinegraphic fileref="gwy_gwy_mutual_crop-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_NEURAL_APPLY:
 *
 * The "Gwy-Neural-Apply" icon.
 * <inlinegraphic fileref="gwy_gwy_neural_apply-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_NEURAL_TRAIN:
 *
 * The "Gwy-Neural-Train" icon.
 * <inlinegraphic fileref="gwy_gwy_neural_train-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_NEXT:
 *
 * The "Gwy-Next" icon.
 * <inlinegraphic fileref="gwy_gwy_next-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_NULL_OFFSETS:
 *
 * The "Gwy-Null-Offsets" icon.
 * <inlinegraphic fileref="gwy_gwy_null_offsets-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PALETTES:
 *
 * The "Gwy-Palettes" icon.
 * <inlinegraphic fileref="gwy_gwy_palettes-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PATH_LEVEL:
 *
 * The "Gwy-Path-Level" icon.
 * <inlinegraphic fileref="gwy_gwy_path_level-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PERSPECTIVE_DISTORT:
 *
 * The "Gwy-Perspective-Distort" icon.
 * <inlinegraphic fileref="gwy_gwy_perspective_distort-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_POINTER_MEASURE:
 *
 * The "Gwy-Pointer-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_pointer_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_POLY_DISTORT:
 *
 * The "Gwy-Poly-Distort" icon.
 * <inlinegraphic fileref="gwy_gwy_poly_distort-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_POLYNOM:
 *
 * The "Gwy-Polynom" icon.
 * <inlinegraphic fileref="gwy_gwy_polynom-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_POLYNOM_LEVEL:
 *
 * The "Gwy-Polynom-Level" icon.
 * <inlinegraphic fileref="gwy_gwy_polynom_level-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PREVIOUS:
 *
 * The "Gwy-Previous" icon.
 * <inlinegraphic fileref="gwy_gwy_previous-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PROFILE:
 *
 * The "Gwy-Profile" icon.
 * <inlinegraphic fileref="gwy_gwy_profile-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PROFILE_MULTIPLE:
 *
 * The "Gwy-Profile-Multiple" icon.
 * <inlinegraphic fileref="gwy_gwy_profile_multiple-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PSDF_LOG_PHI:
 *
 * The "Gwy-PSDF-Log-Phi" icon.
 * <inlinegraphic fileref="gwy_gwy_psdf_log_phi-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PSDF_SECTION:
 *
 * The "Gwy-PSDF-Section" icon.
 * <inlinegraphic fileref="gwy_gwy_psdf_section-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_PYGWY:
 *
 * The "Gwy-Pygwy" icon.
 * <inlinegraphic fileref="gwy_gwy_pygwy-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_RADIAL_PROFILE:
 *
 * The "Gwy-Radial-Profile" icon.
 * <inlinegraphic fileref="gwy_gwy_radial_profile-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_RANK_FILTER:
 *
 * The "Gwy-Rank-Filter" icon.
 * <inlinegraphic fileref="gwy_gwy_rank_filter-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_RASTERIZE:
 *
 * The "Gwy-Rasterize" icon.
 * <inlinegraphic fileref="gwy_gwy_rasterize-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_REMOVE_UNDER_MASK:
 *
 * The "Gwy-Remove-Under-Mask" icon.
 * <inlinegraphic fileref="gwy_gwy_remove_under_mask-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_REVOLVE_ARC:
 *
 * The "Gwy-Revolve-Arc" icon.
 * <inlinegraphic fileref="gwy_gwy_revolve_arc-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_REVOLVE_SPHERE:
 *
 * The "Gwy-Revolve-Sphere" icon.
 * <inlinegraphic fileref="gwy_gwy_revolve_sphere-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ROTATE:
 *
 * The "Gwy-Rotate" icon.
 * <inlinegraphic fileref="gwy_gwy_rotate-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ROTATE_180:
 *
 * The "Gwy-Rotate-180" icon.
 * <inlinegraphic fileref="gwy_gwy_rotate_180-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ROTATE_3D:
 *
 * The "Gwy-Rotate-3D" icon.
 * <inlinegraphic fileref="gwy_gwy_rotate_3d-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ROTATE_90_CCW:
 *
 * The "Gwy-Rotate-90-CCW" icon.
 * <inlinegraphic fileref="gwy_gwy_rotate_90_ccw-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ROTATE_90_CW:
 *
 * The "Gwy-Rotate-90-CW" icon.
 * <inlinegraphic fileref="gwy_gwy_rotate_90_cw-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SCALE:
 *
 * The "Gwy-Scale" icon.
 * <inlinegraphic fileref="gwy_gwy_scale-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SCALE_HORIZONTALLY:
 *
 * The "Gwy-Scale-Horizontally" icon.
 * <inlinegraphic fileref="gwy_gwy_scale_horizontally-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SCALE_VERTICALLY:
 *
 * The "Gwy-Scale-Vertically" icon.
 * <inlinegraphic fileref="gwy_gwy_scale_vertically-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SCARS:
 *
 * The "Gwy-Scars" icon.
 * <inlinegraphic fileref="gwy_gwy_scars-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SCIENTIFIC_NUMBER_FORMAT:
 *
 * The "Gwy-Scientific-Number-Format" icon.
 * <inlinegraphic fileref="gwy_gwy_scientific_number_format-18.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SELECTIONS:
 *
 * The "Gwy-Selections" icon.
 * <inlinegraphic fileref="gwy_gwy_selections-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SHADER:
 *
 * The "Gwy-Shader" icon.
 * <inlinegraphic fileref="gwy_gwy_shader-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SPECTRUM:
 *
 * The "Gwy-Spectrum" icon.
 * <inlinegraphic fileref="gwy_gwy_spectrum-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SPOT_REMOVE:
 *
 * The "Gwy-Spot-Remove" icon.
 * <inlinegraphic fileref="gwy_gwy_spot_remove-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SQUARE_SAMPLES:
 *
 * The "Gwy-Square-Samples" icon.
 * <inlinegraphic fileref="gwy_gwy_square_samples-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_STAT_QUANTITIES:
 *
 * The "Gwy-Stat-Quantities" icon.
 * <inlinegraphic fileref="gwy_gwy_stat_quantities-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_STITCH:
 *
 * The "Gwy-Stitch" icon.
 * <inlinegraphic fileref="gwy_gwy_stitch-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_STRAIGHTEN_PATH:
 *
 * The "Gwy-Straighten-Path" icon.
 * <inlinegraphic fileref="gwy_gwy_straighten_path-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SUBSCRIPT:
 *
 * The "Gwy-Subscript" icon.
 * <inlinegraphic fileref="gwy_gwy_subscript-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SUPERSCRIPT:
 *
 * The "Gwy-Superscript" icon.
 * <inlinegraphic fileref="gwy_gwy_superscript-20.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_ANNEAL:
 *
 * The "Gwy-Synthetic-Anneal" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_anneal-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_BALLISTIC_DEPOSITION:
 *
 * The "Gwy-Synthetic-Ballistic-Deposition" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_ballistic_deposition-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_BROWNIAN_MOTION:
 *
 * The "Gwy-Synthetic-Brownian-Motion" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_brownian_motion-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_COLUMNAR:
 *
 * The "Gwy-Synthetic-Columnar" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_columnar-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DIFFUSION:
 *
 * The "Gwy-Synthetic-Diffusion" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_diffusion-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DISCS:
 *
 * The "Gwy-Synthetic-Discs" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_discs-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DOMAINS:
 *
 * The "Gwy-Synthetic-Domains" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_domains-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DUNES:
 *
 * The "Gwy-Synthetic-Dunes" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_dunes-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_FIBRES:
 *
 * The "Gwy-Synthetic-Fibres" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_fibres-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_LATTICE:
 *
 * The "Gwy-Synthetic-Lattice" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_lattice-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_LINE_NOISE:
 *
 * The "Gwy-Synthetic-Line-Noise" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_line_noise-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_NOISE:
 *
 * The "Gwy-Synthetic-Noise" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_noise-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_OBJECTS:
 *
 * The "Gwy-Synthetic-Objects" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_objects-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PARTICLES:
 *
 * The "Gwy-Synthetic-Particles" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_particles-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PATTERN:
 *
 * The "Gwy-Synthetic-Pattern" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_pattern-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PHASES:
 *
 * The "Gwy-Synthetic-Phases" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_phases-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PILEUP:
 *
 * The "Gwy-Synthetic-Pileup" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_pileup-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PLATEAUS:
 *
 * The "Gwy-Synthetic-Plateaus" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_plateaus-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_SPECTRAL:
 *
 * The "Gwy-Synthetic-Spectral" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_spectral-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_TURING_PATTERN:
 *
 * The "Gwy-Synthetic-Turing-Pattern" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_turing_pattern-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_WAVES:
 *
 * The "Gwy-Synthetic-Waves" icon.
 * <inlinegraphic fileref="gwy_gwy_synthetic_waves-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TERRACE_MEASURE:
 *
 * The "Gwy-Terrace-Measure" icon.
 * <inlinegraphic fileref="gwy_gwy_terrace_measure-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TILT:
 *
 * The "Gwy-Tilt" icon.
 * <inlinegraphic fileref="gwy_gwy_tilt-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_DILATION:
 *
 * The "Gwy-Tip-Dilation" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_dilation-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_EROSION:
 *
 * The "Gwy-Tip-Erosion" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_erosion-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_ESTIMATION:
 *
 * The "Gwy-Tip-Estimation" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_estimation-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_INDENT_ANALYZE:
 *
 * The "Gwy-Tip-Indent-Analyze" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_indent_analyze-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_LATERAL_FORCE:
 *
 * The "Gwy-Tip-Lateral-Force" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_lateral_force-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_MAP:
 *
 * The "Gwy-Tip-Map" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_map-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_MODEL:
 *
 * The "Gwy-Tip-Model" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_model-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TIP_PID:
 *
 * The "Gwy-Tip-Pid" icon.
 * <inlinegraphic fileref="gwy_gwy_tip_pid-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_TRANSLATE_PERIODICALLY:
 *
 * The "Gwy-Translate-Periodically" icon.
 * <inlinegraphic fileref="gwy_gwy_translate_periodically-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_UNROTATE:
 *
 * The "Gwy-Unrotate" icon.
 * <inlinegraphic fileref="gwy_gwy_unrotate-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VALUE_INVERT:
 *
 * The "Gwy-Value-Invert" icon.
 * <inlinegraphic fileref="gwy_gwy_value_invert-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME:
 *
 * The "Gwy-Volume" icon.
 * <inlinegraphic fileref="gwy_gwy_volume-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_ARITHMETIC:
 *
 * The "Gwy-Volume-Arithmetic" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_arithmetic-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_CALIBRATE:
 *
 * The "Gwy-Volume-Calibrate" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_calibrate-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_DIMENSIONS:
 *
 * The "Gwy-Volume-Dimensions" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_dimensions-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_FD:
 *
 * The "Gwy-Volume-FD" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_fd-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_INVERT:
 *
 * The "Gwy-Volume-Invert" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_invert-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_KMEANS:
 *
 * The "Gwy-Volume-Kmeans" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_kmeans-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_KMEDIANS:
 *
 * The "Gwy-Volume-Kmedians" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_kmedians-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_LINE_STATS:
 *
 * The "Gwy-Volume-Line-Stats" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_line_stats-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_PLANE_STATS:
 *
 * The "Gwy-Volume-Plane-Stats" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_plane_stats-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_SLICE:
 *
 * The "Gwy-Volume-Slice" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_slice-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUME_SWAP_AXES:
 *
 * The "Gwy-Volume-Swap-Axes" icon.
 * <inlinegraphic fileref="gwy_gwy_volume_swap_axes-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUMIZE:
 *
 * The "Gwy-Volumize" icon.
 * <inlinegraphic fileref="gwy_gwy_volumize-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_VOLUMIZE_LAYERS:
 *
 * The "Gwy-Volumize-Layers" icon.
 * <inlinegraphic fileref="gwy_gwy_volumize_layers-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_WRAP_VALUE:
 *
 * The "Gwy-Wrap-Value" icon.
 * <inlinegraphic fileref="gwy_gwy_wrap_value-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_XY_DENOISE:
 *
 * The "Gwy-Xy-Denoise" icon.
 * <inlinegraphic fileref="gwy_gwy_xy_denoise-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_XYZIZE:
 *
 * The "Gwy-Xyzize" icon.
 * <inlinegraphic fileref="gwy_gwy_xyzize-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZERO_MAXIMUM:
 *
 * The "Gwy-Zero-Maximum" icon.
 * <inlinegraphic fileref="gwy_gwy_zero_maximum-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZERO_MEAN:
 *
 * The "Gwy-Zero-Mean" icon.
 * <inlinegraphic fileref="gwy_gwy_zero_mean-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZERO_UNDER_MASK:
 *
 * The "Gwy-Zero-Under-Mask" icon.
 * <inlinegraphic fileref="gwy_gwy_zero_under_mask-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZOOM_1_1:
 *
 * The "Gwy-Zoom-1:1" icon.
 * <inlinegraphic fileref="gwy_gwy_zoom_1_1-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZOOM_FIT:
 *
 * The "Gwy-Zoom-Fit" icon.
 * <inlinegraphic fileref="gwy_gwy_zoom_fit-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZOOM_IN:
 *
 * The "Gwy-Zoom-In" icon.
 * <inlinegraphic fileref="gwy_gwy_zoom_in-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_ZOOM_OUT:
 *
 * The "Gwy-Zoom-Out" icon.
 * <inlinegraphic fileref="gwy_gwy_zoom_out-24.png" format="PNG"/>
 **/

/**
 * GWY_ICON_GWYDDION:
 *
 * The "Gwyddion" icon.
 * <inlinegraphic fileref="gwy_gwyddion-60.png" format="PNG"/>
 **/

/* @@@ GENERATED ICON LIST END @@@ */

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
