#pragma once
/*
 *  $Id: layer-point.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_LAYER_POINT_H__
#define __GWYUI_LAYER_POINT_H__

#include <libgwyui/gwyvectorlayer.h>

G_BEGIN_DECLS

#define GWY_TYPE_LAYER_POINT            (gwy_layer_point_get_type())
#define GWY_LAYER_POINT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_LAYER_POINT, GwyLayerPoint))
#define GWY_LAYER_POINT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_LAYER_POINT, GwyLayerPointClass))
#define GWY_IS_LAYER_POINT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_LAYER_POINT))
#define GWY_IS_LAYER_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_LAYER_POINT))
#define GWY_LAYER_POINT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_LAYER_POINT, GwyLayerPointClass))

typedef struct _GwyLayerPoint             GwyLayerPoint;
typedef struct _GwyLayerPointClass        GwyLayerPointClass;
typedef struct _GwyLayerPointPrivate      GwyLayerPointPrivate;

struct _GwyLayerPoint {
    GwyVectorLayer parent_instance;
    GwyLayerPointPrivate *priv;
};

struct _GwyLayerPointClass {
    GwyVectorLayerClass parent_class;
};

GType           gwy_layer_point_get_type          (void)                     G_GNUC_CONST;
GwyVectorLayer* gwy_layer_point_new               (void);
gboolean        gwy_layer_point_get_draw_marker   (GwyLayerPoint *layer);
void            gwy_layer_point_set_draw_marker   (GwyLayerPoint *layer,
                                                   gboolean draw_marker);
gboolean        gwy_layer_point_get_draw_as_vector(GwyLayerPoint *layer);
void            gwy_layer_point_set_draw_as_vector(GwyLayerPoint *layer,
                                                   gboolean draw_as_vector);
gboolean        gwy_layer_point_get_numbered      (GwyLayerPoint *layer);
void            gwy_layer_point_set_numbered      (GwyLayerPoint *layer,
                                                   gboolean numbered);
gdouble         gwy_layer_point_get_marker_radius (GwyLayerPoint *layer);
void            gwy_layer_point_set_marker_radius (GwyLayerPoint *layer,
                                                   gdouble marker_radius);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
