#pragma once
/*
 *  $Id: widget-impl-utils.h 28292 2025-07-25 17:47:42Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_WIDGET_IMPL_UTILS_H__
#define __GWYUI_WIDGET_IMPL_UTILS_H__

#include <cairo/cairo.h>
#include <gtk/gtk.h>

/* FIXME: This should perhaps be a private header, or most of it should be. We sort the functions later. */

G_BEGIN_DECLS

#define float_to_hex(c) ((guint8)((c)*255.9999999))

GdkWindow*       gwy_create_widget_input_window     (GtkWidget *widget,
                                                     GdkEventMask event_mask);
void             gwy_destroy_widget_input_window    (GtkWidget *widget,
                                                     GdkWindow **window);
GtkStyleContext* gwy_setup_widget_foreground_drawing(GtkWidget *widget,
                                                     cairo_t *cr);
void             gwy_switch_window_cursor           (GdkWindow *window,
                                                     const gchar **name,
                                                     const gchar *newname);

static inline gint
get_natural_text_height(GtkWidget *widget)
{
    gint height;

    PangoLayout *layout = gtk_widget_create_pango_layout(widget, "(Qy)");
    pango_layout_set_single_paragraph_mode(layout, TRUE);
    pango_layout_get_pixel_size(layout, NULL, &height);
    g_object_unref(layout);

    return height;
}

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
