dnl Create simple --enable option $1, creating enable_$2 with help text $3,
dnl Default for $2 is $1.  Default option value is $4 (yes if not given).
AC_DEFUN([GWY_ENABLE],
[
AC_ARG_ENABLE([$1],
  AS_HELP_STRING([--enable-$1],
                 [$3 @<:@default=ifelse($4,,yes,$4)@:>@]),
  [case "${enableval}" in
     yes|no) ifelse([$2],,[enable_$1="$enableval"],[enable_$2="$enableval"]) ;;
     *) AC_MSG_ERROR(bad value ${enableval} for --enable-$1) ;;
   esac],
  [ifelse($2,,[enable_$1=ifelse($4,,yes,$4)],[enable_$2=ifelse($4,,yes,$4)])])
])

dnl Create simple --with option $1, creating enable_$2 with help text $3,
dnl Default for $2 is $1.  Default option value is $4 (yes if not given).
AC_DEFUN([GWY_WITH],
[
AC_ARG_WITH([$1],
  AS_HELP_STRING([--with-$1],
                 [$3 @<:@default=ifelse($4,,yes,$4)@:>@]),
  [case "${withval}" in
     yes|no) ifelse([$2],,[enable_$1="$withval"],[enable_$2="$withval"]) ;;
     *) AC_MSG_ERROR(bad value ${withval} for --with-$1) ;;
   esac],
  [ifelse($2,,[enable_$1=ifelse($4,,yes,$4)],[enable_$2=ifelse($4,,yes,$4)])])
])

dnl Create simple --with option $3 with a ‘build with $3’ help string.
dnl Define shell variable enable_$4 for the result.
dnl The default for $4 is $3.
dnl The default option value is $5 (yes if not given).
dnl The help string can be overriden with $6.
dnl If the option is enabled, run pkg-config check to see whether $2
dnl package is actually available, and adjust the result accordingly.
dnl Define Makefile variables and conditionals with $1 prefix accordingly.
dnl
dnl Examples:
dnl
dnl GWY_WITH_PACKAGE(CFITSIO,[cfitsio],[cfitsio])
dnl adds optional compilation with package cfitsio (enabled by default).
dnl
dnl GWY_WITH_PACKAGE(JSON_GLIB,[json-glib >= 1.6],[json-glib],[json_glib],[no])
dnl add optional compilation with package json-glib, where we need to use
dnl dashes and underscores for different things, making it disabled by default.
dnl
dnl FIXME: The ifelse() could be probably compactified to some variable name
dnl indirection. But it may not necessarily make it clearer.
AC_DEFUN([GWY_WITH_PACKAGE],
[
GWY_WITH($3,$4,ifelse($6,,[build with $3],$6),$5)
ifelse($4,,[if test "x$enable_$3" != "xno"; then
  PKG_CHECK_MODULES($1, [$2],
                    [AC_DEFINE(HAVE_$1,1,
                               [Define if we have the $3 package.])],
                    [enable_$3=no])
fi
AM_CONDITIONAL([HAVE_$1],[test "x$enable_$3" != xno])],
[if test "x$enable_$4" != "xno"; then
  PKG_CHECK_MODULES($1, [$2],
                    [AC_DEFINE(HAVE_$1,1,
                               [Define if we have the $3 package.])],
                    [enable_$4=no])
fi
AM_CONDITIONAL([HAVE_$1],[test "x$enable_$4" != xno])
])
])
