/*
 *  $Id: string-list.c 28135 2025-06-24 14:51:47Z yeti-dn $
 *  Copyright (C) 2009-2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "tests/testlibgwy.h"

void
test_string_list_append(void)
{
    GwyStringList *strlist = gwy_string_list_new();

    g_assert_cmpuint(gwy_string_list_get_length(strlist), ==, 0);
    gwy_string_list_append(strlist, "First");
    g_assert_cmpuint(gwy_string_list_get_length(strlist), ==, 1);
    gwy_string_list_append_take(strlist, g_strdup("Second"));
    g_assert_cmpuint(gwy_string_list_get_length(strlist), ==, 2);

    g_assert_cmpstr(gwy_string_list_get(strlist, 0), ==, "First");
    g_assert_cmpstr(gwy_string_list_get(strlist, 1), ==, "Second");

    gwy_string_list_clear(strlist);
    g_assert_cmpuint(gwy_string_list_get_length(strlist), ==, 0);

    g_assert_finalize_object(strlist);
}

static void
string_list_assert_equal(GObject *object, GObject *reference)
{
    g_assert_true(GWY_IS_STRING_LIST(object));
    g_assert_true(GWY_IS_STRING_LIST(reference));

    GwyStringList *strlist = GWY_STRING_LIST(object), *strlist_ref = GWY_STRING_LIST(reference);
    g_assert_cmpuint(gwy_string_list_get_length(strlist), ==, gwy_string_list_get_length(strlist_ref));
    guint n = gwy_string_list_get_length(strlist_ref);
    for (guint i = 0; i < n; i++) {
        g_assert_cmpstr(gwy_string_list_get(strlist, i), ==, gwy_string_list_get(strlist_ref, i));
    }
}

static GwyStringList*
create_string_list_for_serialization(void)
{
    GwyStringList *strlist = gwy_string_list_new();
    gwy_string_list_append(strlist, "one");
    gwy_string_list_append(strlist, "two");
    gwy_string_list_append(strlist, "four");
    return strlist;
}

void
test_string_list_serialize_simple(void)
{
    GwyStringList *strlist = gwy_string_list_new();
    gwy_string_list_append(strlist, "AAAAAA");
    gwy_string_list_append(strlist, "B&B");
    gwy_string_list_append(strlist, "see");
    serialize_object_and_back(G_OBJECT(strlist), string_list_assert_equal, FALSE, NULL);
    g_assert_finalize_object(strlist);
}

void
test_string_list_copy(void)
{
    GwyStringList *strlist = create_string_list_for_serialization();
    serializable_test_copy(GWY_SERIALIZABLE(strlist), string_list_assert_equal);
    g_assert_finalize_object(strlist);
}

void
test_string_list_assign(void)
{
    GwyStringList *strlist = create_string_list_for_serialization();
    GwyStringList *another = gwy_string_list_new();
    gwy_string_list_append(another, "x");
    serializable_test_assign(GWY_SERIALIZABLE(strlist), GWY_SERIALIZABLE(another), string_list_assert_equal);
    g_assert_finalize_object(another);
    g_assert_finalize_object(strlist);
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
