/*
 *  $Id: testlibgwy.h 28921 2025-11-28 10:55:42Z yeti-dn $
 *  Copyright (C) 2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __TESTLIBGWY_H__
#define __TESTLIBGWY_H__ 1

#undef G_DISABLE_ASSERT
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include "libgwyddion/gwyddion.h"
#include "libgwyui/gwyui.h"
#include "libgwyapp/gwyapp.h"

typedef struct _GwySerTest      GwySerTest;
typedef struct _GwySerTestClass GwySerTestClass;

typedef void (*CompareObjectDataFunc)(GObject *object, GObject *reference);

// Helpers
gchar*      ensure_test_data_dir             (void);
void        assert_subprocesses_critical_fail(const gchar *prefix,
                                              guint64 timeout,
                                              GTestSubprocessFlags test_flags,
                                              ...);
void        assert_error_list                (GwyErrorList *error_list,
                                              GwyErrorList *expected_errors);
void        dump_error_list                  (GwyErrorList *error_list);
void        record_finalisation              (gpointer pcanary,
                                              GObject *where_the_object_was);
gboolean    values_are_equal                 (const GValue *value1,
                                              const GValue *value2);
GObject*    serialize_object_and_back        (GObject *object,
                                              CompareObjectDataFunc compare,
                                              gboolean return_reconstructed,
                                              GwyErrorList *expected_errors);
gpointer    serialize_boxed_and_back         (gpointer boxed,
                                              GType type,
                                              gboolean return_reconstructed);
gboolean    assert_properties_equal          (GObject *object,
                                              GObject *reference);
gboolean    compare_containers               (GwyContainer *dict,
                                              GwyContainer *reference);
void        serializable_test_copy           (GwySerializable *serializable,
                                              CompareObjectDataFunc compare);
void        serializable_test_assign         (GwySerializable *serializable,
                                              GwySerializable *assign_to,
                                              CompareObjectDataFunc compare);
void        deserialize_assert_failure       (GMemoryOutputStream *stream,
                                              GwyErrorList *expected_errors);
void        record_item_change               (GObject *object,
                                              guint pos,
                                              guint64 *counter);
void        record_signal                    (guint *counter);
GwySerTest* gwy_ser_test_new_filled          (gboolean flag,
                                              const gdouble *data,
                                              guint ndata,
                                              const gchar *str,
                                              guint32 raw);
void        dict_assert_equal                (GObject *object,
                                              GObject *reference);
void        line_assert_equal                (GObject *object,
                                              GObject *reference);
void        field_assert_equal               (GObject *object,
                                              GObject *reference);
void        curve_model_assert_equal         (GObject *object,
                                              GObject *reference);
GwyNield*   make_random_mask                 (gint xres,
                                              gint yres,
                                              gboolean also_negative,
                                              gint maxgno);

GType gwy_ser_test_get_type(void) G_GNUC_CONST;

#define GWY_TYPE_SER_TEST           (gwy_ser_test_get_type())
#define GWY_SER_TEST(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_SER_TEST, GwySerTest))
#define GWY_IS_SER_TEST(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_SER_TEST))
#define GWY_SER_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_SER_TEST, GwySerTestClass))

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
