#pragma once
/*
 *  $Id: data-browser-internal.h 28665 2025-10-17 17:05:59Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti)
 *  E-mail: yeti@gwyddion.net
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*< private_header >*/

#ifndef __GWYAPP_DATA_BROWSER_INTERNAL_H__
#define __GWYAPP_DATA_BROWSER_INTERNAL_H__

G_BEGIN_DECLS

typedef struct {
    gint fileno;
    GwyDataKind data_kind;
    gint id;
} SwitchTo;

typedef struct _DataBrowserGUI DataBrowserGUI;
typedef struct _DataBrowser DataBrowser;
typedef struct _FileProxyGUI FileProxyGUI;
typedef struct _FileProxy FileProxy;

typedef struct {
    FileProxy *proxy;
    GtkWindow *window;
    GObject *object;
    GdkPixbuf *thumbnail;
    gdouble thumbnail_timestamp;
    gdouble changed_timestamp;
    gulong signal_id;
    gulong signal_id2;
    gulong signal_id3;
    gulong window_destroyed_id;
    gulong focus_event_id;
    GtkTreeIter iter;
    GwyFileKeyParsed parsed;
    GQuark key;
} PieceInfo;

/* All kinds of extra data we hold about a file. */
struct _FileProxy {
    GwyFile *file;
    GHashTable *qpieces;          /* Maps item quarks to PieceInfo structs. */
    gint current_items[GWY_FILE_N_KINDS];
    gulong item_changed_id;
    /* TODO: Count OpenGL windows into visible count. */
    guint visible_count;
    gboolean resetting_visibility;

    /* For data browser GUI (mostly backend structures). When GUI is disabled, these are NULL/unset and generally
     * ignored. They could be split into another struct, but we would need to manage the memory twice and some parts
     * (like tree models) can be accessed accross source files. */
    GtkTreeModel *lists[GWY_FILE_N_KINDS];
    GArray *messages;
    GtkTextBuffer *message_textbuf;
    GtkWidget *message_window;
    GLogLevelFlags log_levels_seen;
};

struct _DataBrowser {
    GList *proxies;               /* Cannot use an array here to have stable proxy pointers. */
    FileProxy *current_file;
    GwyDataKind current_kind;
    GHashTable *files;            /* Maps file ids to managed File objects. */
    GHashTable *objpieces;        /* Maps object pointers (not necessarily primary data) to PieceInfo structs. */
    gint last_fileid;
    gint block_switching;
    SwitchTo switch_to;
    GArray *watchers;
    gulong last_watcherid;
    gboolean gui_enabled;

    DataBrowserGUI *gui;
};


G_GNUC_INTERNAL void         _gwy_file_set_managed                     (GwyFile *file,
                                                                        gboolean is_managed);
G_GNUC_INTERNAL void         _gwy_file_set_id                          (GwyFile *file,
                                                                        gint id);
G_GNUC_INTERNAL DataBrowser* _gwy_data_browser                         (void)                   G_GNUC_CONST;
G_GNUC_INTERNAL void         _gwy_data_browser_gui_switch_current      (void);
G_GNUC_INTERNAL void         _gwy_data_browser_update_filename         (void);
G_GNUC_INTERNAL void         _gwy_data_browser_update_sensitivity_flags(GwyDataKind data_kind,
                                                                        const PieceInfo *info);

/* Use doubles for timestamps.  They have 53bit mantisa, which is sufficient for microsecond precision. */
G_GNUC_UNUSED
static inline gdouble
get_timestamp_now(void)
{
    return 1e-6*g_get_monotonic_time();
}

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
