#pragma once
/*
 *  $Id: data-browser.h 29477 2026-02-14 13:29:30Z yeti-dn $
 *  Copyright (C) 2006-2025 David Necas (Yeti), Petr Klapetek, Chris Anderson
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net, sidewinderasu@gmail.com.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_DATA_BROWSER_H__
#define __GWYAPP_DATA_BROWSER_H__

#include <gtk/gtk.h>
#include <libgwyddion/field.h>
#include <libgwyddion/brick.h>
#include <libgwyddion/spectra.h>
#include <libgwyddion/surface.h>
#include <libgwyddion/lawn.h>
#include <libgwyui/gwydataview.h>
#include <libgwyui/graph.h>
#include <libgwyapp/file.h>

G_BEGIN_DECLS

/* XXX: Only transitional, to be removed once modules get direct data arguments and no longer rely on figuring out
 * what is currently selected in the browser. */
typedef enum {
    GWY_APP_FILE = 1,
    GWY_APP_DATA_KIND,
    GWY_APP_DATA_VIEW,
    GWY_APP_GRAPH,
    GWY_APP_FIELD,
    GWY_APP_FIELD_KEY,
    GWY_APP_FIELD_ID,
    GWY_APP_MASK_FIELD,
    GWY_APP_MASK_FIELD_KEY,
    GWY_APP_SHOW_FIELD,
    GWY_APP_SHOW_FIELD_KEY,
    GWY_APP_GRAPH_MODEL,
    GWY_APP_GRAPH_MODEL_KEY,
    GWY_APP_GRAPH_MODEL_ID,
    GWY_APP_SPECTRA,
    GWY_APP_SPECTRA_KEY,
    GWY_APP_SPECTRA_ID,
    GWY_APP_VOLUME_VIEW,
    GWY_APP_BRICK,
    GWY_APP_BRICK_KEY,
    GWY_APP_BRICK_ID,
    GWY_APP_FILE_ID,
    GWY_APP_XYZ_VIEW,
    GWY_APP_SURFACE,
    GWY_APP_SURFACE_KEY,
    GWY_APP_SURFACE_ID,
    GWY_APP_LAWN,
    GWY_APP_LAWN_KEY,
    GWY_APP_LAWN_ID,
    GWY_APP_CURVE_MAP_VIEW,
} GwyAppWhat;

typedef enum {
    GWY_VISIBILITY_RESET_DEFAULT,
    GWY_VISIBILITY_RESET_RESTORE,
    GWY_VISIBILITY_RESET_SHOW_ALL,
    GWY_VISIBILITY_RESET_HIDE_ALL
} GwyVisibilityResetType;

typedef enum {
    GWY_DATA_WATCH_EVENT_ADDED,
    GWY_DATA_WATCH_EVENT_CHANGED,
    GWY_DATA_WATCH_EVENT_REMOVED
} GwyDataWatchEventType;

typedef void (*GwyDataBrowserForeachFunc)(GwyFile *file,
                                          gpointer user_data);
typedef void (*GwyDataWatchFunc)(GwyFile *file,
                                 gint id,
                                 GwyDataWatchEventType event,
                                 gpointer user_data);

/* Make Files managed/unmanaged. */
void     gwy_data_browser_add     (GwyFile *file);
void     gwy_data_browser_remove  (GwyFile *file);
GwyFile* gwy_data_browser_get_file(gint id);

/* Useful utility functions. */
gint   gwy_data_browser_copy_data         (GwyFile *source,
                                           GwyDataKind data_kind,
                                           gint id,
                                           GwyFile *dest);
gint gwy_data_browser_reset_visibility(GwyFile *file,
                                       GwyVisibilityResetType reset_type);
GwyFile* gwy_data_browser_find_object(GObject *object,
                                      GQuark *key);

/* This must be in the data browser (not File) because it only goes through managed Files. */
void   gwy_data_browser_foreach         (GwyDataBrowserForeachFunc function,
                                         gpointer user_data,
                                         GDestroyNotify destroy);

/* Keeping track of current data, data switching and widget-data associations. The find_data() vs. find_window() is
 * asymmetric because find_data() can accept any reasonable widget but find_window() must return a specific widget.
 * Toplevel makes the most sense. */
void       gwy_data_browser_select_widget      (GtkWidget *widget);
GtkWindow* gwy_data_browser_get_window_for_data(GwyFile *file,
                                                GwyDataKind data_kind,
                                                gint id);
gboolean   gwy_data_browser_get_data_for_widget(GtkWidget *widget,
                                                GwyFile **file,
                                                GwyDataKind *data_kind,
                                                gint *id);
void       gwy_data_browser_select_data        (GwyFile *file,
                                                GwyDataKind data_kind,
                                                gint id);
void       gwy_data_browser_block_switching    (void);
void       gwy_data_browser_unblock_switching  (void);
/* How much convenience is the possibility to pass a zillion different things here? Or just a mess? We really need
 * just the id. Maybe keep it for smoother transition and we will see then. */
GwyDataKind gwy_data_browser_get_current_data_kind(void);
GwyFile*    gwy_data_browser_get_current_file     (void);
gint        gwy_data_browser_get_current_file_id  (void);
gint        gwy_data_browser_get_current_data_id  (GwyDataKind data_kind);
void        gwy_data_browser_get_current          (GwyAppWhat what,
                                                   ...);

/* Data kind watches. */
gulong gwy_data_browser_add_watch     (GwyDataWatchFunc function,
                                       GwyDataKind data_kind,
                                       gpointer user_data,
                                       GDestroyNotify destroy);
void gwy_data_browser_remove_watch(gulong id);

/* Browser GUI. It will be embeddable widget now, not a window. This will be a separate source file. */
gboolean   gwy_data_browser_get_gui_enabled(void);
void       gwy_data_browser_set_gui_enabled(gboolean setting);
GtkWidget* gwy_data_browser_widget         (void);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
