#pragma once
/*
 *  $Id: enums.h 29161 2026-01-11 14:57:58Z yeti-dn $
 *  Copyright (C) 2005-2018 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_ENUMS_H__
#define __GWY_ENUMS_H__

#include <glib.h>
#include <libgwyddion/enum.h>

G_BEGIN_DECLS

typedef enum {
    GWY_ORIENTATION_HORIZONTAL = 0,
    GWY_ORIENTATION_VERTICAL = 1
} GwyOrientation;

typedef enum {
    GWY_DIRECTION_HORIZONTAL = 1u << GWY_ORIENTATION_HORIZONTAL,
    GWY_DIRECTION_VERTICAL   = 1u << GWY_ORIENTATION_VERTICAL,
    GWY_DIRECTION_BOTH       = GWY_DIRECTION_HORIZONTAL | GWY_DIRECTION_VERTICAL,
} GwyDirectionFlags;

typedef enum {
    GWY_SIGN_NEGATIVE = 1u << 0,
    GWY_SIGN_POSITIVE = 1u << 1,
    GWY_SIGN_BOTH     = GWY_SIGN_NEGATIVE |  GWY_SIGN_POSITIVE,
} GwySignFlags;

typedef enum {
    GWY_TRANSFORM_DIRECTION_BACKWARD = -1,
    GWY_TRANSFORM_DIRECTION_FORWARD = 1
} GwyTransformDirection;

typedef enum {
    GWY_MASK_EXCLUDE = 0,
    GWY_MASK_INCLUDE = 1,
    GWY_MASK_IGNORE  = 2,
} GwyMaskingType;

typedef enum {
    GWY_COMPUTATION_STATE_INIT,
    GWY_COMPUTATION_STATE_ITERATE,
    GWY_COMPUTATION_STATE_FINISHED
} GwyComputationStateType;

typedef enum {
    GWY_PLANE_FIT_A = 1,
    GWY_PLANE_FIT_BX,
    GWY_PLANE_FIT_BY,
    GWY_PLANE_FIT_ANGLE,
    GWY_PLANE_FIT_SLOPE,
    GWY_PLANE_FIT_S0,
    GWY_PLANE_FIT_S0_REDUCED
} GwyPlaneFitQuantity;

typedef enum {
    GWY_WINDOWING_NONE       = 0,
    GWY_WINDOWING_HANN       = 1,
    GWY_WINDOWING_HAMMING    = 2,
    GWY_WINDOWING_BLACKMANN  = 3,
    GWY_WINDOWING_LANCZOS    = 4,
    GWY_WINDOWING_WELCH      = 5,
    GWY_WINDOWING_RECT       = 6,
    GWY_WINDOWING_NUTTALL    = 7,
    GWY_WINDOWING_FLAT_TOP   = 8,
    GWY_WINDOWING_KAISER25   = 9
} GwyWindowingType;

typedef enum {
    GWY_CORR_SEARCH_COVARIANCE_RAW    = 0,
    GWY_CORR_SEARCH_COVARIANCE        = 1,
    GWY_CORR_SEARCH_COVARIANCE_SCORE  = 2,
    GWY_CORR_SEARCH_HEIGHT_DIFF_RAW   = 3,
    GWY_CORR_SEARCH_HEIGHT_DIFF       = 4,
    GWY_CORR_SEARCH_HEIGHT_DIFF_SCORE = 5,
    GWY_CORR_SEARCH_PHASE_ONLY_SCORE  = 6,
} GwyCorrSearchType;

typedef enum {
    GWY_ROTATE_RESIZE_SAME_SIZE = 0,
    GWY_ROTATE_RESIZE_EXPAND    = 1,
    GWY_ROTATE_RESIZE_CUT       = 2,
} GwyRotateResizeType;

const GwyEnum* gwy_merge_type_get_enum        (void) G_GNUC_CONST;
const GwyEnum* gwy_masking_type_get_enum      (void) G_GNUC_CONST;
const GwyEnum* gwy_orientation_get_enum       (void) G_GNUC_CONST;
const GwyEnum* gwy_interpolation_type_get_enum(void) G_GNUC_CONST;
const GwyEnum* gwy_windowing_type_get_enum    (void) G_GNUC_CONST;
const GwyEnum* gwy_correlation_type_get_enum  (void) G_GNUC_CONST;
const GwyEnum* gwy_direction_flags_get_enum   (void) G_GNUC_CONST;
const GwyEnum* gwy_sign_flags_get_enum        (void) G_GNUC_CONST;

/* Well, this is not exactly an enum... */
typedef struct {
    /*<public>*/
    guint state;
    gdouble fraction;
} GwyComputationState;

#define GWY_TYPE_COMPUTATION_STATE (gwy_computation_state_get_type())

GType   gwy_computation_state_get_type    (void)                           G_GNUC_CONST;
gint    gwy_computation_state_get_state   (GwyComputationState *compstate) G_GNUC_PURE;
gdouble gwy_computation_state_get_fraction(GwyComputationState *compstate) G_GNUC_PURE;

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
