#pragma once
/*
 *  $Id: fractals.h 29416 2026-01-30 16:49:54Z yeti-dn $
 *  Copyright (C) 2003-2026 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_FRACTALS_H__
#define __GWY_FRACTALS_H__

#include <libgwyddion/field.h>

G_BEGIN_DECLS

void    gwy_field_fractal_partitioning     (GwyField *field,
                                            GwyLine *xresult,
                                            GwyLine *yresult,
                                            GwyInterpolationType interpolation);
void    gwy_field_fractal_cubecounting     (GwyField *field,
                                            GwyLine *xresult,
                                            GwyLine *yresult,
                                            GwyInterpolationType interpolation);
void    gwy_field_fractal_triangulation    (GwyField *field,
                                            GwyLine *xresult,
                                            GwyLine *yresult,
                                            GwyInterpolationType interpolation);
void    gwy_field_fractal_psdf             (GwyField *field,
                                            GwyLine *xresult,
                                            GwyLine *yresult,
                                            GwyInterpolationType interpolation);
void    gwy_field_fractal_hhcf             (GwyField *field,
                                            GwyLine *xresult,
                                            GwyLine *yresult);
gdouble gwy_field_fractal_cubecounting_dim (GwyLine *xresult,
                                            GwyLine *yresult,
                                            gdouble *a,
                                            gdouble *b);
gdouble gwy_field_fractal_triangulation_dim(GwyLine *xresult,
                                            GwyLine *yresult,
                                            gdouble *a,
                                            gdouble *b);
gdouble gwy_field_fractal_partitioning_dim (GwyLine *xresult,
                                            GwyLine *yresult,
                                            gdouble *a,
                                            gdouble *b);
gdouble gwy_field_fractal_psdf_dim         (GwyLine *xresult,
                                            GwyLine *yresult,
                                            gdouble *a,
                                            gdouble *b);
gdouble gwy_field_fractal_hhcf_dim         (GwyLine *xresult,
                                            GwyLine *yresult,
                                            gdouble *a,
                                            gdouble *b);
void    gwy_field_fractal_correction       (GwyField *field,
                                            GwyNield *mask,
                                            GwyInterpolationType interpolation);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
