#pragma once
/*
 *  $Id: grains.h 29461 2026-02-11 18:15:37Z yeti-dn $
 *  Copyright (C) 2025-2026 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_GRAINS_H__
#define __GWY_GRAINS_H__

#include <libgwyddion/nield.h>
#include <libgwyddion/field.h>
#include <libgwyddion/types.h>

G_BEGIN_DECLS

/* These are numbered according to the basic 16 logical operations. Not all are terribly useful, but keep the
 * corresponding numbers < 16 reserved in case we implement more. */
typedef enum {
    GWY_MERGE_CLEAR        = 0,
    GWY_MERGE_INTERSECTION = 1,
    GWY_MERGE_AND          = 1,
    GWY_MERGE_MIN          = 1,
    GWY_MERGE_SUBTRACT     = 2,
    GWY_MERGE_KEEP         = 3,
    GWY_MERGE_REVSUBTRACT  = 4,
    GWY_MERGE_COPY         = 5,
    GWY_MERGE_XOR          = 6,
    GWY_MERGE_UNION        = 7,
    GWY_MERGE_OR           = 7,
    GWY_MERGE_MAX          = 7,
    GWY_MERGE_NOR          = 8,
    GWY_MERGE_OUTSIDE      = 8,
    GWY_MERGE_NXOR         = 9,
    GWY_MERGE_EQUAL        = 9,
    GWY_MERGE_NCOPY        = 10,
    GWY_MERGE_CONVERSE     = 11,
    GWY_MERGE_NOT          = 12,
    GWY_MERGE_IMPLIES      = 13,
    GWY_MERGE_NAND         = 14,
    GWY_MERGE_FILL         = 15,
} GwyMergeType;

gboolean gwy_nield_isolate                   (GwyNield *nield,
                                              gint number,
                                              gint *bbox);
gboolean gwy_nield_isolate_at                (GwyNield *nield,
                                              gint col,
                                              gint row,
                                              gint *bbox);
gboolean gwy_nield_clear_at                  (GwyNield *nield,
                                              gint col,
                                              gint row);
void     gwy_nield_clear_by_number           (GwyNield *nield,
                                              gint number,
                                              gboolean compactify);
void     gwy_nield_clear_by_size             (GwyNield *nield,
                                              gint size);
void     gwy_nield_clear_touching_border     (GwyNield *nield,
                                              gboolean completely);
void     gwy_nield_mark_by_threshold         (GwyNield *nield,
                                              GwyField *field,
                                              gdouble threshold,
                                              gboolean above);
void     gwy_nield_mark_range                (GwyNield *nield,
                                              GwyField *field,
                                              gdouble lower,
                                              gdouble upper);
void     gwy_nield_union                     (GwyNield *nield,
                                              GwyNield *union_with);
void     gwy_nield_intersect                 (GwyNield *nield,
                                              GwyNield *intersect_with);
void     gwy_nield_merge                     (GwyNield *nield,
                                              GwyNield *operand,
                                              GwyMergeType operation);
void     gwy_nield_invert                    (GwyNield *nield);
gboolean gwy_nield_autocrop                  (GwyNield *nield,
                                              gboolean symmetrically,
                                              guint *left,
                                              guint *right,
                                              guint *up,
                                              guint *down);
gint     gwy_nield_compactify                (GwyNield *nield);
gboolean gwy_nield_flatten                   (GwyNield *nield);
gint     gwy_nield_number_contiguous         (GwyNield *nield);
gint     gwy_nield_number_contiguous_periodic(GwyNield *nield);
gint     gwy_nield_split_noncontiguous       (GwyNield *nield);
gint*    gwy_nield_grain_numbers             (GwyNield *nield,
                                              gint *ngrains);
guint*   gwy_nield_sizes                     (GwyNield *nield,
                                              gint *maxgno);
gboolean gwy_nield_fill_voids                (GwyNield *nield,
                                              gboolean nonsimple);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
