#pragma once
/*
 *  $Id: nield.h 29433 2026-02-03 15:17:00Z yeti-dn $
 *  Copyright (C) 2025-2026 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_field_H__
#define __GWY_field_H__

#include <glib.h>
#include <glib-object.h>
#include <libgwyddion/enums.h>

G_BEGIN_DECLS

#define GWY_TYPE_NIELD            (gwy_nield_get_type())
#define GWY_NIELD(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_NIELD, GwyNield))
#define GWY_NIELD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_NIELD, GwyNieldClass))
#define GWY_IS_NIELD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_NIELD))
#define GWY_IS_NIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_NIELD))
#define GWY_NIELD_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_NIELD, GwyNieldClass))

typedef struct _GwyNield        GwyNield;
typedef struct _GwyNieldClass   GwyNieldClass;
typedef struct _GwyNieldPrivate GwyNieldPrivate;

struct _GwyNield {
    GObject parent_instance;
    GwyNieldPrivate *priv;

    gint xres;
    gint yres;
};

struct _GwyNieldClass {
    GObjectClass parent_class;

    void (*data_changed)(GwyNield *nield);

    /*< private >*/
    void (*reserved1)(void);
    void (*reserved2)(void);
};

G_END_DECLS

#include <libgwyddion/field.h>

G_BEGIN_DECLS

GType       gwy_nield_get_type       (void)                   G_GNUC_CONST;
GwyNield*   gwy_nield_new            (gint xres,
                                      gint yres)              G_GNUC_MALLOC;
GwyNield*   gwy_nield_new_alike      (GwyNield *model)        G_GNUC_MALLOC;
GwyNield*   gwy_nield_copy           (GwyNield *nield)        G_GNUC_MALLOC;
void        gwy_nield_assign         (GwyNield *destination,
                                      GwyNield *source);
void        gwy_nield_invalidate     (GwyNield *nield);
void        gwy_nield_data_changed   (GwyNield *nield);
void        gwy_nield_resize         (GwyNield *nield,
                                      gint xres,
                                      gint yres);
void        gwy_nield_crop           (GwyNield *nield,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height);
GwyNield*   gwy_nield_area_extract   (GwyNield *nield,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height);
void        gwy_nield_copy_data      (GwyNield *nield,
                                      GwyNield *target);
void        gwy_nield_area_copy      (GwyNield *src,
                                      GwyNield *dest,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height,
                                      gint destcol,
                                      gint destrow);
gint*       gwy_nield_get_data       (GwyNield *nield);
const gint* gwy_nield_get_data_const (GwyNield *nield);
gint        gwy_nield_get_xres       (GwyNield *nield);
gint        gwy_nield_get_yres       (GwyNield *nield);
gint        gwy_nield_max            (GwyNield *nield);
gint        gwy_nield_get_val        (GwyNield *nield,
                                      gint col,
                                      gint row);
void        gwy_nield_set_val        (GwyNield *nield,
                                      gint col,
                                      gint row,
                                      gint value);
GwyNield*   gwy_nield_new_rotated_90 (GwyNield *nield,
                                      gboolean clockwise);
GwyNield*   gwy_nield_new_resampled  (GwyNield *nield,
                                      gint xres,
                                      gint yres);
void        gwy_nield_flip           (GwyNield *nield,
                                      gboolean xflipped,
                                      gboolean yflipped);
void        gwy_nield_transpose      (GwyNield *src,
                                      GwyNield *dest,
                                      gboolean minor);
void        gwy_nield_area_transpose (GwyNield *src,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height,
                                      GwyNield *dest,
                                      gboolean minor);
void        gwy_nield_fill           (GwyNield *nield,
                                      gint value);
void        gwy_nield_area_fill      (GwyNield *nield,
                                      GwyNield *mask,
                                      GwyMaskingType mode,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height,
                                      gint value);
void        gwy_nield_clear          (GwyNield *nield);
void        gwy_nield_area_clear     (GwyNield *nield,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height);
guint       gwy_nield_count          (GwyNield *nield);
guint       gwy_nield_area_count     (GwyNield *nield,
                                      GwyNield *mask,
                                      GwyMaskingType mode,
                                      gint col,
                                      gint row,
                                      gint width,
                                      gint height);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
