#pragma once
/*
 *  $Id: shaped.h 29372 2026-01-27 17:29:28Z yeti-dn $
 *  Copyright (C) 2005-2026 David Necas (Yeti), Petr Klapetek, Chris Anderson.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net, sidewinder.asu@gmail.com.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_SHAPED_H__
#define __GWY_SHAPED_H__

#include <libgwyddion/field.h>

G_BEGIN_DECLS

gsize    gwy_field_elliptic_area_fill   (GwyField *field,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height,
                                         gdouble value);
gsize    gwy_nield_elliptic_area_fill   (GwyNield *nield,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height,
                                         gint value);
gsize    gwy_nield_elliptic_fill        (GwyNield *nield);
gsize    gwy_field_elliptic_area_extract(GwyField *field,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height,
                                         gdouble *data,
                                         gint *rcols,
                                         gint *rrows);
gsize    gwy_nield_elliptic_area_extract(GwyNield *nield,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height,
                                         gint *data,
                                         gint *rcols,
                                         gint *rrows);
void     gwy_field_elliptic_area_insert (GwyField *field,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height,
                                         const gdouble *data);
void     gwy_nield_elliptic_area_insert (GwyNield *nield,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height,
                                         const gint *data);
gsize    gwy_elliptic_area_size         (gint width,
                                         gint height);
gsize    gwy_elliptic_intersection_size (gint xres,
                                         gint yres,
                                         gint col,
                                         gint row,
                                         gint width,
                                         gint height);
gsize    gwy_field_circular_area_fill   (GwyField *field,
                                         gint col,
                                         gint row,
                                         gdouble radius,
                                         gdouble value);
gsize    gwy_nield_circular_area_fill   (GwyNield *nield,
                                         gint col,
                                         gint row,
                                         gdouble radius,
                                         gint value);
gsize    gwy_field_circular_area_extract(GwyField *field,
                                         gint col,
                                         gint row,
                                         gdouble radius,
                                         gdouble *data,
                                         gint *rcols,
                                         gint *rrows);
gsize    gwy_nield_circular_area_extract(GwyNield *nield,
                                         gint col,
                                         gint row,
                                         gdouble radius,
                                         gint *data,
                                         gint *rcols,
                                         gint *rrows);
void     gwy_field_circular_area_insert (GwyField *field,
                                         gint col,
                                         gint row,
                                         gdouble radius,
                                         const gdouble *data);
void     gwy_nield_circular_area_insert (GwyNield *nield,
                                         gint col,
                                         gint row,
                                         gdouble radius,
                                         const gint *data);
gsize    gwy_circular_area_size         (gdouble radius);
gsize    gwy_nield_linear_area_fill     (GwyNield *nield,
                                         gint col1,
                                         gint row1,
                                         gint col2,
                                         gint row2,
                                         gboolean connect4,
                                         gint value);
gsize    gwy_nield_linear_area_extract  (GwyNield *nield,
                                         gint col1,
                                         gint row1,
                                         gint col2,
                                         gint row2,
                                         gboolean connect4,
                                         gint *data,
                                         gint *rcols,
                                         gint *rrows);
void     gwy_nield_linear_area_insert   (GwyNield *nield,
                                         gint col1,
                                         gint row1,
                                         gint col2,
                                         gint row2,
                                         gboolean connect4,
                                         const gint *data);
gsize    gwy_linear_area_size           (gint col1,
                                         gint row1,
                                         gint col2,
                                         gint row2,
                                         gboolean connect4);
gboolean gwy_field_local_maximum        (GwyField *field,
                                         gdouble *x,
                                         gdouble *y,
                                         gint ax,
                                         gint ay);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
