#pragma once
/*
 *  $Id: stats.h 29416 2026-01-30 16:49:54Z yeti-dn $
 *  Copyright (C) 2003-2026 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_STATS_H__
#define __GWY_STATS_H__

#include <libgwyddion/nield.h>
#include <libgwyddion/field.h>
#include <libgwyddion/linestats.h>

G_BEGIN_DECLS

typedef enum {
    GWY_MINKOWSKI_VOLUME,
    GWY_MINKOWSKI_BOUNDARY,
    GWY_MINKOWSKI_BLACK,
    GWY_MINKOWSKI_WHITE,
    GWY_MINKOWSKI_CONNECTIVITY,
} GwyMinkowskiFunctional;

typedef enum {
    GWY_FIELD_VOLUME_DEFAULT     = 0,
    GWY_FIELD_VOLUME_GWYDDION2   = 1,
    GWY_FIELD_VOLUME_TRIANGULAR  = 2,
    GWY_FIELD_VOLUME_BILINEAR    = 3,
    GWY_FIELD_VOLUME_BIQUADRATIC = 4,
} GwyFieldVolumeMethod;

gdouble  gwy_field_max                     (GwyField *field);
gdouble  gwy_field_min                     (GwyField *field);
void     gwy_field_min_max                 (GwyField *field,
                                            gdouble *min,
                                            gdouble *max);
gdouble  gwy_field_mean                    (GwyField *field);
gdouble  gwy_field_rms                     (GwyField *field);
gdouble  gwy_field_mean_square             (GwyField *field);
gdouble  gwy_field_sum                     (GwyField *field);
gdouble  gwy_field_median                  (GwyField *field);
gdouble  gwy_field_surface_area            (GwyField *field);
gdouble  gwy_field_rms_slope               (GwyField *field);
gdouble  gwy_field_variation               (GwyField *field);
gdouble  gwy_field_entropy                 (GwyField *field);
gdouble  gwy_field_entropy_2d              (GwyField *xfield,
                                            GwyField *yfield);
gdouble  gwy_field_otsu_threshold          (GwyField *field);
gdouble  gwy_field_area_max                (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_min                (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
void     gwy_field_area_min_max            (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble *min,
                                            gdouble *max);
gdouble  gwy_field_area_mean               (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_rms                (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_grainwise_rms      (GwyField *field,
                                            GwyNield *nield,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_sum                (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_median             (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_surface_area       (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_rms_slope          (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_mean_square        (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_entropy_at_scales  (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gint maxdiv);
gdouble  gwy_field_entropy_2d_at_scales    (GwyField *xfield,
                                            GwyField *yfield,
                                            GwyLine *target_line,
                                            gint maxdiv);
gdouble  gwy_field_area_variation          (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_entropy            (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_volume             (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            GwyFieldVolumeMethod method,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height);
gdouble  gwy_field_area_material_volume    (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gboolean material,
                                            gdouble base);
void     gwy_field_autorange               (GwyField *field,
                                            gdouble *from,
                                            gdouble *to);
void     gwy_field_area_autorange          (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble *from,
                                            gdouble *to);
void     gwy_field_stats                   (GwyField *field,
                                            gdouble *avg,
                                            gdouble *ra,
                                            gdouble *rms,
                                            gdouble *skew,
                                            gdouble *kurtosis);
void     gwy_field_area_stats              (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble *avg,
                                            gdouble *ra,
                                            gdouble *rms,
                                            gdouble *skew,
                                            gdouble *kurtosis);
void     gwy_field_area_count_in_range     (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble below,
                                            gdouble above,
                                            gint *nbelow,
                                            gint *nabove);
void     gwy_field_area_height_dist        (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gint nstats);
void     gwy_field_height_dist             (GwyField *field,
                                            GwyLine *target_line,
                                            gint nstats);
void     gwy_field_area_angle_dist         (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyOrientation orientation,
                                            gint nstats);
void     gwy_field_angle_dist              (GwyField *field,
                                            GwyLine *target_line,
                                            GwyOrientation orientation,
                                            gint nstats);
void     gwy_field_area_acf                (GwyField *field,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyOrientation orientation);
void     gwy_field_acf                     (GwyField *field,
                                            GwyLine *target_line,
                                            GwyOrientation orientation);
void     gwy_field_area_hhcf               (GwyField *field,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyOrientation orientation);
void     gwy_field_hhcf                    (GwyField *field,
                                            GwyLine *target_line,
                                            GwyOrientation orientation);
void     gwy_field_area_psdf               (GwyField *field,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyOrientation orientation,
                                            GwyWindowingType windowing);
void     gwy_field_psdf                    (GwyField *field,
                                            GwyLine *target_line,
                                            GwyOrientation orientation,
                                            GwyWindowingType windowing);
void     gwy_field_area_rpsdf              (GwyField *field,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyWindowingType windowing,
                                            gint nstats);
void     gwy_field_rpsdf                   (GwyField *field,
                                            GwyLine *target_line,
                                            GwyWindowingType windowing,
                                            gint nstats);
void     gwy_field_area_ipsdf              (GwyField *field,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyWindowingType windowing,
                                            gint nstats);
void     gwy_field_ipsdf                   (GwyField *field,
                                            GwyLine *target_line,
                                            GwyWindowingType windowing,
                                            gint nstats);
GwyLine* gwy_field_area_row_acf            (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            guint col,
                                            guint row,
                                            guint width,
                                            guint height,
                                            guint level,
                                            GwyLine *weights);
GwyLine* gwy_field_area_row_hhcf           (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            guint col,
                                            guint row,
                                            guint width,
                                            guint height,
                                            guint level,
                                            GwyLine *weights);
GwyLine* gwy_field_area_row_psdf           (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            guint col,
                                            guint row,
                                            guint width,
                                            guint height,
                                            GwyWindowingType windowing,
                                            guint level);
GwyLine* gwy_field_area_row_asg            (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            guint col,
                                            guint row,
                                            guint width,
                                            guint height,
                                            guint level);
void     gwy_field_area_acf_2d             (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            GwyField *target,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gint xrange,
                                            gint yrange,
                                            GwyField *weights);
void     gwy_field_acf_2d                  (GwyField *field,
                                            GwyField *target_field);
void     gwy_field_area_psdf_2d            (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            GwyField *target,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyWindowingType windowing,
                                            gint level);
void     gwy_field_psdf_2d                 (GwyField *field,
                                            GwyField *target_field,
                                            GwyWindowingType windowing,
                                            gint level);
void     gwy_field_area_racf               (GwyField *field,
                                            GwyLine *target_line,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gint nstats);
void     gwy_field_racf                    (GwyField *field,
                                            GwyLine *target_line,
                                            gint nstats);
GwyLine* gwy_field_minkowski               (GwyField *field,
                                            GwyMinkowskiFunctional type,
                                            gint nstats);
GwyLine* gwy_field_area_minkowski          (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyMinkowskiFunctional type,
                                            gint nstats,
                                            gdouble min,
                                            gdouble max);
gdouble  gwy_field_area_dispersion         (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble *xcenter,
                                            gdouble *ycenter);
gdouble  gwy_field_dispersion              (GwyField *field,
                                            gdouble *xcenter,
                                            gdouble *ycenter);
void     gwy_field_slope_distribution      (GwyField *field,
                                            GwyLine *derdist,
                                            gint kernel_size);
void     gwy_field_facet_distribution      (GwyField *field,
                                            GwyField *dist,
                                            gint half_res,
                                            gint size,
                                            GwyField *theta_field,
                                            GwyField *phi_field);
void     gwy_field_normal_coeffs           (GwyField *field,
                                            gdouble *nx,
                                            gdouble *ny,
                                            gdouble *nz);
gint     gwy_field_area_normal_coeffs      (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble *nx,
                                            gdouble *ny,
                                            gdouble *nz);
void     gwy_field_inclination             (GwyField *field,
                                            gdouble *theta,
                                            gdouble *phi);
void     gwy_field_area_inclination        (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            gdouble *theta,
                                            gdouble *phi);
void     gwy_field_line_stats              (GwyField *field,
                                            GwyLine *target_line,
                                            GwyLineStatQuantity quantity,
                                            GwyOrientation orientation);
GwyLine* gwy_field_area_line_stats         (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gint col,
                                            gint row,
                                            gint width,
                                            gint height,
                                            GwyLineStatQuantity quantity,
                                            GwyOrientation orientation,
                                            GwyLine *weights);
guint    gwy_field_count_maxima            (GwyField *field);
guint    gwy_field_count_minima            (GwyField *field);
GwyLine* gwy_field_psdf_to_angular_spectrum(GwyField *psdf,
                                            gint nstats);
GwyLine* gwy_field_angular_average         (GwyField *field,
                                            GwyNield *mask,
                                            GwyMaskingType masking,
                                            gdouble x,
                                            gdouble y,
                                            gdouble r,
                                            gint nstats);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
