#pragma once
/*
 *  $Id: surface.h 29431 2026-02-03 00:36:52Z yeti-dn $
 *  Copyright (C) 2011-2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_SURFACE_H__
#define __GWY_SURFACE_H__

#include <libgwyddion/math.h>
#include <libgwyddion/enums.h>
#include <libgwyddion/field.h>

G_BEGIN_DECLS

#define GWY_TYPE_SURFACE            (gwy_surface_get_type())
#define GWY_SURFACE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_SURFACE, GwySurface))
#define GWY_SURFACE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_SURFACE, GwySurfaceClass))
#define GWY_IS_SURFACE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_SURFACE))
#define GWY_IS_SURFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_SURFACE))
#define GWY_SURFACE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_SURFACE, GwySurfaceClass))

typedef struct _GwySurface        GwySurface;
typedef struct _GwySurfaceClass   GwySurfaceClass;
typedef struct _GwySurfacePrivate GwySurfacePrivate;

struct _GwySurface {
    GObject parent_instance;
    GwySurfacePrivate *priv;

    /*<public>*/
    guint n;
};

struct _GwySurfaceClass {
    GObjectClass parent_class;

    void (*data_changed)(GwySurface *surface);
    /*< private >*/
    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType           gwy_surface_get_type           (void)                      G_GNUC_CONST;
GwySurface*     gwy_surface_new                (void);
GwySurface*     gwy_surface_new_sized          (guint n);
GwySurface*     gwy_surface_new_from_data      (const GwyXYZ *points,
                                                guint n);
GwySurface*     gwy_surface_new_alike          (GwySurface *model);
GwySurface*     gwy_surface_new_part           (GwySurface *surface,
                                                gdouble xfrom,
                                                gdouble xto,
                                                gdouble yfrom,
                                                gdouble yto);
GwyXYZ*         gwy_surface_get_data           (GwySurface *surface);
const GwyXYZ*   gwy_surface_get_data_const     (GwySurface *surface);
guint           gwy_surface_get_npoints        (GwySurface *surface);
void            gwy_surface_copy_data          (GwySurface *surface,
                                                GwySurface *target);
void            gwy_surface_invalidate         (GwySurface *surface);
void            gwy_surface_data_changed       (GwySurface *surface);
GwySurface*     gwy_surface_copy               (GwySurface *surface);
void            gwy_surface_assign             (GwySurface *destination,
                                                GwySurface *source);
void            gwy_surface_set_from_field     (GwySurface *surface,
                                                GwyField *field);
void            gwy_surface_set_from_field_area(GwySurface *surface,
                                                GwyField *field,
                                                GwyNield *mask,
                                                GwyMaskingType masking,
                                                gint col,
                                                gint row,
                                                gint width,
                                                gint height);
GwyUnit*        gwy_surface_get_unit_xy        (GwySurface *surface);
GwyUnit*        gwy_surface_get_unit_z         (GwySurface *surface);
GwyValueFormat* gwy_surface_get_value_format_xy(GwySurface *surface,
                                                GwyUnitFormatStyle style,
                                                GwyValueFormat *format);
GwyValueFormat* gwy_surface_get_value_format_z (GwySurface *surface,
                                                GwyUnitFormatStyle style,
                                                GwyValueFormat *format);
void            gwy_surface_copy_units         (GwySurface *surface,
                                                GwySurface *target);
void            gwy_field_copy_units_to_surface(GwyField *field,
                                                GwySurface *surface);
void            gwy_surface_copy_units_to_field(GwySurface *surface,
                                                GwyField *field);
GwyXYZ          gwy_surface_get                (GwySurface *surface,
                                                guint pos);
void            gwy_surface_set                (GwySurface *surface,
                                                guint pos,
                                                GwyXYZ point);
void            gwy_surface_xrange             (GwySurface *surface,
                                                gdouble *min,
                                                gdouble *max);
void            gwy_surface_yrange             (GwySurface *surface,
                                                gdouble *min,
                                                gdouble *max);
void            gwy_surface_min_max            (GwySurface *surface,
                                                gdouble *min,
                                                gdouble *max);
void            gwy_surface_multiply           (GwySurface *surface,
                                                gdouble value);
void            gwy_surface_add                (GwySurface *surface,
                                                gdouble value);
void            gwy_surface_scale_xy           (GwySurface *surface,
                                                gdouble xfactor,
                                                gdouble yfactor,
                                                gdouble xoffset,
                                                gdouble yoffset);
const GwyXYZ*   gwy_surface_get_data_full      (GwySurface *surface,
                                                gsize *n);
void            gwy_surface_set_data_full      (GwySurface *surface,
                                                const GwyXYZ *points,
                                                gsize n);
gboolean        gwy_surface_xy_is_compatible   (GwySurface *surface,
                                                GwySurface *othersurface);
GwySurface*     gwy_surface_reduce_points      (GwySurface *surface,
                                                gsize npoints);
void            gwy_surface_resize             (GwySurface *surface,
                                                gsize npoints);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
