#pragma once
/*
 *  $Id: tip.h 29540 2026-02-24 14:00:46Z yeti-dn $
 *  Copyright (C) 2003-2026 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_TIP_H__
#define __GWY_TIP_H__

#include <libgwyddion/field.h>

G_BEGIN_DECLS

gboolean gwy_field_tip_dilation        (GwyField *field,
                                        GwyField *tip,
                                        GwyField *result,
                                        gboolean max_is_zero,
                                        GwySetFractionFunc set_fraction,
                                        GwySetMessageFunc set_message);
gboolean gwy_field_tip_erosion         (GwyField *field,
                                        GwyField *tip,
                                        GwyField *result,
                                        gboolean max_is_zero,
                                        GwySetFractionFunc set_fraction,
                                        GwySetMessageFunc set_message);
gboolean gwy_field_tip_certainty_map   (GwyField *field,
                                        GwyField *tip,
                                        GwyNield *result,
                                        gboolean trust_border,
                                        GwySetFractionFunc set_fraction,
                                        GwySetMessageFunc set_message);
gint     gwy_field_tip_estimate_partial(GwyField *field,
                                        GwyField *tip,
                                        gdouble threshold,
                                        gboolean use_edges,
                                        GwySetFractionFunc set_fraction,
                                        GwySetMessageFunc set_message);
gint     gwy_field_tip_estimate_full   (GwyField *field,
                                        GwyField *tip,
                                        gdouble threshold,
                                        gboolean use_edges,
                                        GwySetFractionFunc set_fraction,
                                        GwySetMessageFunc set_message);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
