#pragma once
/*
 *  $Id: watershed.h 29416 2026-01-30 16:49:54Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_WATERSHED_H__
#define __GWY_WATERSHED_H__

#include <libgwyddion/nield.h>
#include <libgwyddion/field.h>
#include <libgwyddion/types.h>

G_BEGIN_DECLS

typedef enum {
    GWY_WATERSHED_STATE_INIT,
    GWY_WATERSHED_STATE_LOCATE,
    GWY_WATERSHED_STATE_MIN,
    GWY_WATERSHED_STATE_WATERSHED,
    GWY_WATERSHED_STATE_MARK,
    GWY_WATERSHED_STATE_FINISHED
} GwyWatershedStateType;

void                 gwy_field_splash_water       (GwyField *field,
                                                   GwyNield *water,
                                                   GwyField *markbuf,
                                                   gint locate_steps,
                                                   gdouble locate_dropsize);
GwyComputationState* gwy_field_watershed_init     (GwyField *field,
                                                   GwyNield *grains,
                                                   gint locate_steps,
                                                   gint locate_thresh,
                                                   gdouble locate_dropsize,
                                                   gint wshed_steps,
                                                   gdouble wshed_dropsize,
                                                   gboolean prefilter,
                                                   gboolean below);
void                 gwy_field_watershed_iteration(GwyComputationState *state);
void                 gwy_field_watershed_finalize (GwyComputationState *state);
gint                 gwy_field_waterpour          (GwyField *field,
                                                   GwyNield *grains);
void                 gwy_field_mark_extrema       (GwyField *field,
                                                   GwyNield *extrema,
                                                   gboolean maxima);
void                 gwy_field_mark_watershed     (GwyField *field,
                                                   GwyNield *grains,
                                                   gint locate_steps,
                                                   gint locate_thresh,
                                                   gdouble locate_dropsize,
                                                   gint wshed_steps,
                                                   gdouble wshed_dropsize,
                                                   gboolean prefilter,
                                                   gboolean below);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */

