#pragma once
/*
 *  $Id: gwydataviewlayer.h 29478 2026-02-14 13:56:53Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_DATA_VIEW_LAYER_H__
#define __GWYUI_DATA_VIEW_LAYER_H__

#include <gtk/gtk.h>
#include <libgwyddion/dict.h>

G_BEGIN_DECLS

#define GWY_TYPE_DATA_VIEW_LAYER            (gwy_data_view_layer_get_type())
#define GWY_DATA_VIEW_LAYER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_DATA_VIEW_LAYER, GwyDataViewLayer))
#define GWY_DATA_VIEW_LAYER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_DATA_VIEW_LAYER, GwyDataViewLayerClass))
#define GWY_IS_DATA_VIEW_LAYER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_DATA_VIEW_LAYER))
#define GWY_IS_DATA_VIEW_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_DATA_VIEW_LAYER))
#define GWY_DATA_VIEW_LAYER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_DATA_VIEW_LAYER, GwyDataViewLayerClass))

typedef struct _GwyDataViewLayer             GwyDataViewLayer;
typedef struct _GwyDataViewLayerClass        GwyDataViewLayerClass;
typedef struct _GwyDataViewLayerPrivate      GwyDataViewLayerPrivate;
typedef struct _GwyDataViewLayerClassPrivate GwyDataViewLayerClassPrivate;

struct _GwyDataViewLayer {
    GInitiallyUnowned parent_instance;
    GwyDataViewLayerPrivate *priv;

    /* TODO GTK3 review public fields. But it will probably look different anyway. */
    GwyDict *data;
};

/*
 * The realize()/unrealize() methods are used by vector layers to cache PangoThings, GDK cursors and similar
 * things. This may be just added complexity. Just use gtk_widget_create_pango_layout() and watch for
 * "screen-changed".
 *
 * In any case, add an API which provides these things from here, instead of doing it in all layer implementations.
 * Just recreate everything. If we decide to cache and handle updates, do it in one place: here. */
struct _GwyDataViewLayerClass {
    GInitiallyUnownedClass parent_class;
    GwyDataViewLayerClassPrivate *priv;

    /* Signals */
    void (*plugged)(GwyDataViewLayer *layer);
    void (*unplugged)(GwyDataViewLayer *layer);
    void (*updated)(GwyDataViewLayer *layer);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
};

GType      gwy_data_view_layer_get_type  (void)                     G_GNUC_CONST;
void       gwy_data_view_layer_set_parent(GwyDataViewLayer *layer,
                                          GtkWidget *parent);
GtkWidget* gwy_data_view_layer_get_parent(GwyDataViewLayer *layer);
void       gwy_data_view_layer_updated   (GwyDataViewLayer *layer);
void       gwy_data_view_layer_realize   (GwyDataViewLayer *layer);
void       gwy_data_view_layer_unrealize (GwyDataViewLayer *layer);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
