#pragma once
/*
 *  $Id: gwyglview.h 29477 2026-02-14 13:29:30Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *  Copyright (C) 2004 Martin Siler.
 *  E-mail: silerm@physics.muni.cz.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GL_VIEW_H__
#define __GWYUI_GL_VIEW_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <libgwyddion/field.h>
#include <libgwyddion/gradient.h>
#include <libgwyddion/gl-material.h>

#include <libgwyui/gwygllabel.h>
#include <libgwyui/gwyglsetup.h>

G_BEGIN_DECLS

#define GWY_TYPE_GL_VIEW            (gwy_gl_view_get_type())
#define GWY_GL_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GL_VIEW, GwyGLView))
#define GWY_GL_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GL_VIEW, GwyGLViewClass))
#define GWY_IS_GL_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GL_VIEW))
#define GWY_IS_GL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GL_VIEW))
#define GWY_GL_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GL_VIEW, GwyGLViewClass))

typedef struct _GwyGLView             GwyGLView;
typedef struct _GwyGLViewClass        GwyGLViewClass;
typedef struct _GwyGLViewPrivate      GwyGLViewPrivate;

/* TODO GTK3 derive from GtkGLArea, not GtkWidget. */
struct _GwyGLView {
    GtkWidget parent_instance;
    GwyGLViewPrivate *priv;
};

struct _GwyGLViewClass {
    GtkWidgetClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
    void (*reserved5)(void);
    void (*reserved6)(void);
};

GtkWidget*   gwy_gl_view_new             (GwyDict *data);
GType        gwy_gl_view_get_type        (void)                G_GNUC_CONST;
const gchar* gwy_gl_view_get_setup_prefix(GwyGLView *glview);
void         gwy_gl_view_set_setup_prefix(GwyGLView *glview,
                                          const gchar *key);
const gchar* gwy_gl_view_get_data_key    (GwyGLView *glview);
void         gwy_gl_view_set_data_key    (GwyGLView *glview,
                                          const gchar *key);
/* This is used in app.c with some direct messing with DataViewLayer->data, etc. Since the data view layers can emit
 * signals when they redraw, it achieves some sort of automatic updating. The entire thing probably needs to be
 * rewritten and once DataView gets zoom the functionality becomes divorced anyway; whereas rendering a GdkPixbuf is
 * easy. So do not worry too much.
void          gwy_gl_view_set_ovlay                 (GwyGLView *glview,
                                                     GwyPixmapLayer **ovlays,
                                                     guint novlays);
                                                     */
const gchar*  gwy_gl_view_get_gradient_key          (GwyGLView *glview);
void          gwy_gl_view_set_gradient_key          (GwyGLView *glview,
                                                     const gchar *key);
const gchar*  gwy_gl_view_get_material_key          (GwyGLView *glview);
void          gwy_gl_view_set_material_key          (GwyGLView *glview,
                                                     const gchar *key);
guint         gwy_gl_view_get_reduced_size          (GwyGLView *glview);
void          gwy_gl_view_set_reduced_size          (GwyGLView *glview,
                                                     guint reduced_size);
GwyGLMovement gwy_gl_view_get_movement_type         (GwyGLView *glview);
void          gwy_gl_view_set_movement_type         (GwyGLView *glview,
                                                     GwyGLMovement movement);
GdkPixbuf*    gwy_gl_view_get_pixbuf                (GwyGLView *glview);
GdkPixbuf*    gwy_gl_view_get_pixbuf_with_alpha     (GwyGLView *glview);
GwyGLLabel*   gwy_gl_view_get_label                 (GwyGLView *glview,
                                                     GwyGLViewLabel label);
GwyGLSetup*   gwy_gl_view_get_setup                 (GwyGLView *glview);
GwyDict* gwy_gl_view_get_data                  (GwyGLView *glview);
void          gwy_gl_view_get_scale_range           (GwyGLView *glview,
                                                     gdouble *min_scale,
                                                     gdouble *max_scale);
void          gwy_gl_view_set_scale_range           (GwyGLView *glview,
                                                     gdouble min_scale,
                                                     gdouble max_scale);
void          gwy_gl_view_class_disable_axis_drawing(gboolean disable);
const gchar*  gwy_gl_view_get_mask_key              (GwyGLView *glview);
void          gwy_gl_view_set_mask_key              (GwyGLView *glview,
                                                     const gchar *key);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
