/*
 *  $Id: icons.c 29226 2026-01-15 09:58:34Z yeti-dn $
 *  Copyright (C) 2003-2026 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "libgwyui/icons.h"

/**
 * SECTION: icons
 * @title: Icons
 * @short_description: Named icons
 *
 * Names icons, mostly intended for specific Gwyddion functions. One can also refer to them by the name directly.
 * However, using the macros provides a compile-time check such icon exists.
 **/

/* The following generated part is updated by running utils/stockgen.py */

/* @@@ GENERATED ICON LIST BEGIN @@@ */
/**
 * GWY_ICON_3D_BASE:
 *
 * The "Gwy-3D-Base" icon.
 * <inlinegraphic fileref="gwy_3d_base.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ARITHMETIC:
 *
 * The "Gwy-Arithmetic" icon.
 * <inlinegraphic fileref="gwy_arithmetic.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_BINNING:
 *
 * The "Gwy-Binning" icon.
 * <inlinegraphic fileref="gwy_binning.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_BOLD:
 *
 * The "Gwy-Bold" icon.
 * <inlinegraphic fileref="gwy_bold.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CANTILEVER:
 *
 * The "Gwy-Cantilever" icon.
 * <inlinegraphic fileref="gwy_cantilever.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE:
 *
 * The "Gwy-Color-Range" icon.
 * <inlinegraphic fileref="gwy_color_range.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_ADAPTIVE:
 *
 * The "Gwy-Color-Range-Adaptive" icon.
 * <inlinegraphic fileref="gwy_color_range_adaptive.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_AUTO:
 *
 * The "Gwy-Color-Range-Auto" icon.
 * <inlinegraphic fileref="gwy_color_range_auto.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_FIXED:
 *
 * The "Gwy-Color-Range-Fixed" icon.
 * <inlinegraphic fileref="gwy_color_range_fixed.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_COLOR_RANGE_FULL:
 *
 * The "Gwy-Color-Range-Full" icon.
 * <inlinegraphic fileref="gwy_color_range_full.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CONVOLUTION:
 *
 * The "Gwy-Convolution" icon.
 * <inlinegraphic fileref="gwy_convolution.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CONVOLVE:
 *
 * The "Gwy-Convolve" icon.
 * <inlinegraphic fileref="gwy_convolve.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CORRECT_AFFINE:
 *
 * The "Gwy-Correct-Affine" icon.
 * <inlinegraphic fileref="gwy_correct_affine.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CORRELATION_LENGTH:
 *
 * The "Gwy-Correlation-Length" icon.
 * <inlinegraphic fileref="gwy_correlation_length.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CORRELATION_MASK:
 *
 * The "Gwy-Correlation-Mask" icon.
 * <inlinegraphic fileref="gwy_correlation_mask.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CROP:
 *
 * The "Gwy-Crop" icon.
 * <inlinegraphic fileref="gwy_crop.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CROSS_PROFILE:
 *
 * The "Gwy-Cross-Profile" icon.
 * <inlinegraphic fileref="gwy_cross_profile.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CURVATURE:
 *
 * The "Gwy-Curvature" icon.
 * <inlinegraphic fileref="gwy_curvature.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_CWT:
 *
 * The "Gwy-CWT" icon.
 * <inlinegraphic fileref="gwy_cwt.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DATA_MEASURE:
 *
 * The "Gwy-Data-Measure" icon.
 * <inlinegraphic fileref="gwy_data_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DECONVOLVE:
 *
 * The "Gwy-Deconvolve" icon.
 * <inlinegraphic fileref="gwy_deconvolve.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DISCONNECTED:
 *
 * The "Gwy-Disconnected" icon.
 * <inlinegraphic fileref="gwy_disconnected.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DISPLACEMENT_FIELD:
 *
 * The "Gwy-Displacement-Field" icon.
 * <inlinegraphic fileref="gwy_displacement_field.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DISTANCE:
 *
 * The "Gwy-Distance" icon.
 * <inlinegraphic fileref="gwy_distance.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DISTANCE_TRANSFORM:
 *
 * The "Gwy-Distance-Transform" icon.
 * <inlinegraphic fileref="gwy_distance_transform.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DISTRIBUTION_ANGLE:
 *
 * The "Gwy-Distribution-Angle" icon.
 * <inlinegraphic fileref="gwy_distribution_angle.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DISTRIBUTION_SLOPE:
 *
 * The "Gwy-Distribution-Slope" icon.
 * <inlinegraphic fileref="gwy_distribution_slope.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DRIFT:
 *
 * The "Gwy-Drift" icon.
 * <inlinegraphic fileref="gwy_drift.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_DWT:
 *
 * The "Gwy-DWT" icon.
 * <inlinegraphic fileref="gwy_dwt.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_EDGE:
 *
 * The "Gwy-Edge" icon.
 * <inlinegraphic fileref="gwy_edge.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ENFORCE_DISTRIBUTION:
 *
 * The "Gwy-Enforce-Distribution" icon.
 * <inlinegraphic fileref="gwy_enforce_distribution.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ENTROPY:
 *
 * The "Gwy-Entropy" icon.
 * <inlinegraphic fileref="gwy_entropy.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_EXTEND:
 *
 * The "Gwy-Extend" icon.
 * <inlinegraphic fileref="gwy_extend.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_EXTRACT_PATH:
 *
 * The "Gwy-Extract-Path" icon.
 * <inlinegraphic fileref="gwy_extract_path.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FACET_ANALYSIS:
 *
 * The "Gwy-Facet-Analysis" icon.
 * <inlinegraphic fileref="gwy_facet_analysis.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FACET_LEVEL:
 *
 * The "Gwy-Facet-Level" icon.
 * <inlinegraphic fileref="gwy_facet_level.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FACET_MEASURE:
 *
 * The "Gwy-Facet-Measure" icon.
 * <inlinegraphic fileref="gwy_facet_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FAVOURITE:
 *
 * The "Gwy-Favourite" icon.
 * <inlinegraphic fileref="gwy_favourite.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FFT:
 *
 * The "Gwy-FFT" icon.
 * <inlinegraphic fileref="gwy_fft.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FFT_2D:
 *
 * The "Gwy-FFT-2D" icon.
 * <inlinegraphic fileref="gwy_fft_2d.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FFT_FILTER_1D:
 *
 * The "Gwy-FFT-Filter-1D" icon.
 * <inlinegraphic fileref="gwy_fft_filter_1d.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FFT_FILTER_2D:
 *
 * The "Gwy-FFT-Filter-2D" icon.
 * <inlinegraphic fileref="gwy_fft_filter_2d.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FILTER:
 *
 * The "Gwy-Filter" icon.
 * <inlinegraphic fileref="gwy_filter.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FIND_PEAKS:
 *
 * The "Gwy-Find-Peaks" icon.
 * <inlinegraphic fileref="gwy_find_peaks.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FIT_SHAPE:
 *
 * The "Gwy-Fit-Shape" icon.
 * <inlinegraphic fileref="gwy_fit_shape.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FIX_ZERO:
 *
 * The "Gwy-Fix-Zero" icon.
 * <inlinegraphic fileref="gwy_fix_zero.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FLIP_DIAGONALLY:
 *
 * The "Gwy-Flip-Diagonally" icon.
 * <inlinegraphic fileref="gwy_flip_diagonally.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FLIP_HORIZONTALLY:
 *
 * The "Gwy-Flip-Horizontally" icon.
 * <inlinegraphic fileref="gwy_flip_horizontally.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FLIP_VERTICALLY:
 *
 * The "Gwy-Flip-Vertically" icon.
 * <inlinegraphic fileref="gwy_flip_vertically.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FRACTAL:
 *
 * The "Gwy-Fractal" icon.
 * <inlinegraphic fileref="gwy_fractal.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FRACTAL_CORRECTION:
 *
 * The "Gwy-Fractal-Correction" icon.
 * <inlinegraphic fileref="gwy_fractal_correction.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FRACTAL_MEASURE:
 *
 * The "Gwy-Fractal-Measure" icon.
 * <inlinegraphic fileref="gwy_fractal_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_FREQUENCY_SPLIT:
 *
 * The "Gwy-Frequency-Split" icon.
 * <inlinegraphic fileref="gwy_frequency_split.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GL_MATERIAL:
 *
 * The "Gwy-GL-Material" icon.
 * <inlinegraphic fileref="gwy_gl_material.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRADIENT_HORIZONTAL:
 *
 * The "Gwy-Gradient-Horizontal" icon.
 * <inlinegraphic fileref="gwy_gradient_horizontal.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRADIENT_VERTICAL:
 *
 * The "Gwy-Gradient-Vertical" icon.
 * <inlinegraphic fileref="gwy_gradient_vertical.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAIN_BOUNDING_BOX:
 *
 * The "Gwy-Grain-Bounding-Box" icon.
 * <inlinegraphic fileref="gwy_grain_bounding_box.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAIN_CIRCUMCIRCLE:
 *
 * The "Gwy-Grain-Circumcircle" icon.
 * <inlinegraphic fileref="gwy_grain_circumcircle.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAIN_CORRELATION:
 *
 * The "Gwy-Grain-Correlation" icon.
 * <inlinegraphic fileref="gwy_grain_correlation.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAIN_INSCRIBED_BOX:
 *
 * The "Gwy-Grain-Inscribed-Box" icon.
 * <inlinegraphic fileref="gwy_grain_inscribed_box.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAIN_INSCRIBED_CIRCLE:
 *
 * The "Gwy-Grain-Inscribed-Circle" icon.
 * <inlinegraphic fileref="gwy_grain_inscribed_circle.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS:
 *
 * The "Gwy-Grains" icon.
 * <inlinegraphic fileref="gwy_grains.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_EDGE:
 *
 * The "Gwy-Grains-Edge" icon.
 * <inlinegraphic fileref="gwy_grains_edge.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_EDGE_REMOVE:
 *
 * The "Gwy-Grains-Edge-Remove" icon.
 * <inlinegraphic fileref="gwy_grains_edge_remove.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_GRAPH:
 *
 * The "Gwy-Grains-Graph" icon.
 * <inlinegraphic fileref="gwy_grains_graph.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_MEASURE:
 *
 * The "Gwy-Grains-Measure" icon.
 * <inlinegraphic fileref="gwy_grains_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_OTSU:
 *
 * The "Gwy-Grains-Otsu" icon.
 * <inlinegraphic fileref="gwy_grains_otsu.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_REMOVE:
 *
 * The "Gwy-Grains-Remove" icon.
 * <inlinegraphic fileref="gwy_grains_remove.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_STATISTICS:
 *
 * The "Gwy-Grains-Statistics" icon.
 * <inlinegraphic fileref="gwy_grains_statistics.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAINS_WATER:
 *
 * The "Gwy-Grains-Water" icon.
 * <inlinegraphic fileref="gwy_grains_water.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH:
 *
 * The "Gwy-Graph" icon.
 * <inlinegraphic fileref="gwy_graph.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_ALIGN:
 *
 * The "Gwy-Graph-Align" icon.
 * <inlinegraphic fileref="gwy_graph_align.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_CUT:
 *
 * The "Gwy-Graph-Cut" icon.
 * <inlinegraphic fileref="gwy_graph_cut.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_DOS:
 *
 * The "Gwy-Graph-Dos" icon.
 * <inlinegraphic fileref="gwy_graph_dos.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_EXPORT_ASCII:
 *
 * The "Gwy-Graph-Export-Ascii" icon.
 * <inlinegraphic fileref="gwy_graph_export_ascii.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_EXPORT_PNG:
 *
 * The "Gwy-Graph-Export-PNG" icon.
 * <inlinegraphic fileref="gwy_graph_export_png.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_EXPORT_VECTOR:
 *
 * The "Gwy-Graph-Export-Vector" icon.
 * <inlinegraphic fileref="gwy_graph_export_vector.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_FD:
 *
 * The "Gwy-Graph-FD" icon.
 * <inlinegraphic fileref="gwy_graph_fd.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_FILTER:
 *
 * The "Gwy-Graph-Filter" icon.
 * <inlinegraphic fileref="gwy_graph_filter.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_FUNCTION:
 *
 * The "Gwy-Graph-Function" icon.
 * <inlinegraphic fileref="gwy_graph_function.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_HALFGAUSS:
 *
 * The "Gwy-Graph-Halfgauss" icon.
 * <inlinegraphic fileref="gwy_graph_halfgauss.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_LEVEL:
 *
 * The "Gwy-Graph-Level" icon.
 * <inlinegraphic fileref="gwy_graph_level.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_MEASURE:
 *
 * The "Gwy-Graph-Measure" icon.
 * <inlinegraphic fileref="gwy_graph_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_PALETTE:
 *
 * The "Gwy-Graph-Palette" icon.
 * <inlinegraphic fileref="gwy_graph_palette.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_PERIOD_MEASURE:
 *
 * The "Gwy-Graph-Period-Measure" icon.
 * <inlinegraphic fileref="gwy_graph_period_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_POINTER:
 *
 * The "Gwy-Graph-Pointer" icon.
 * <inlinegraphic fileref="gwy_graph_pointer.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_RULER:
 *
 * The "Gwy-Graph-Ruler" icon.
 * <inlinegraphic fileref="gwy_graph_ruler.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_STATISTICS:
 *
 * The "Gwy-Graph-Statistics" icon.
 * <inlinegraphic fileref="gwy_graph_statistics.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_TERRACE_MEASURE:
 *
 * The "Gwy-Graph-Terrace-Measure" icon.
 * <inlinegraphic fileref="gwy_graph_terrace_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_VERTICAL:
 *
 * The "Gwy-Graph-Vertical" icon.
 * <inlinegraphic fileref="gwy_graph_vertical.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_ZOOM_FIT:
 *
 * The "Gwy-Graph-Zoom-Fit" icon.
 * <inlinegraphic fileref="gwy_graph_zoom_fit.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_ZOOM_IN:
 *
 * The "Gwy-Graph-Zoom-In" icon.
 * <inlinegraphic fileref="gwy_graph_zoom_in.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GRAPH_ZOOM_OUT:
 *
 * The "Gwy-Graph-Zoom-Out" icon.
 * <inlinegraphic fileref="gwy_graph_zoom_out.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_HOLD_SELECTION_CLEAR:
 *
 * The "Gwy-Hold-Selection-Clear" icon.
 * <inlinegraphic fileref="gwy_hold_selection_clear.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_HOLD_SELECTION_REPLACE:
 *
 * The "Gwy-Hold-Selection-Replace" icon.
 * <inlinegraphic fileref="gwy_hold_selection_replace.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_HOUGH:
 *
 * The "Gwy-Hough" icon.
 * <inlinegraphic fileref="gwy_hough.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_IMAGE_RELATION:
 *
 * The "Gwy-Image-Relation" icon.
 * <inlinegraphic fileref="gwy_image_relation.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_IMMERSE:
 *
 * The "Gwy-Immerse" icon.
 * <inlinegraphic fileref="gwy_immerse.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ISO_ROUGHNESS:
 *
 * The "Gwy-Iso-Roughness" icon.
 * <inlinegraphic fileref="gwy_iso_roughness.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ITALIC:
 *
 * The "Gwy-Italic" icon.
 * <inlinegraphic fileref="gwy_italic.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LESS:
 *
 * The "Gwy-Less" icon.
 * <inlinegraphic fileref="gwy_less.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LEVEL:
 *
 * The "Gwy-Level" icon.
 * <inlinegraphic fileref="gwy_level.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LEVEL_FLATTEN_BASE:
 *
 * The "Gwy-Level-Flatten-Base" icon.
 * <inlinegraphic fileref="gwy_level_flatten_base.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LEVEL_MEDIAN:
 *
 * The "Gwy-Level-Median" icon.
 * <inlinegraphic fileref="gwy_level_median.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LEVEL_TRIANGLE:
 *
 * The "Gwy-Level-Triangle" icon.
 * <inlinegraphic fileref="gwy_level_triangle.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LIGHT_ROTATE:
 *
 * The "Gwy-Light-Rotate" icon.
 * <inlinegraphic fileref="gwy_light_rotate.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LIMIT_RANGE:
 *
 * The "Gwy-Limit-Range" icon.
 * <inlinegraphic fileref="gwy_limit_range.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LINE_LEVEL:
 *
 * The "Gwy-Line-Level" icon.
 * <inlinegraphic fileref="gwy_line_level.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LOAD_DEBUG:
 *
 * The "Gwy-Load-Debug" icon.
 * <inlinegraphic fileref="gwy_load_debug.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LOAD_INFO:
 *
 * The "Gwy-Load-Info" icon.
 * <inlinegraphic fileref="gwy_load_info.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LOAD_WARNING:
 *
 * The "Gwy-Load-Warning" icon.
 * <inlinegraphic fileref="gwy_load_warning.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LOCAL_SLOPE:
 *
 * The "Gwy-Local-Slope" icon.
 * <inlinegraphic fileref="gwy_local_slope.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LOGSCALE_HORIZONTAL:
 *
 * The "Gwy-Logscale-Horizontal" icon.
 * <inlinegraphic fileref="gwy_logscale_horizontal.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_LOGSCALE_VERTICAL:
 *
 * The "Gwy-Logscale-Vertical" icon.
 * <inlinegraphic fileref="gwy_logscale_vertical.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MARK_OUTLIERS:
 *
 * The "Gwy-Mark-Outliers" icon.
 * <inlinegraphic fileref="gwy_mark_outliers.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MARK_SCARS:
 *
 * The "Gwy-Mark-Scars" icon.
 * <inlinegraphic fileref="gwy_mark_scars.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MARK_WITH:
 *
 * The "Gwy-Mark-With" icon.
 * <inlinegraphic fileref="gwy_mark_with.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK:
 *
 * The "Gwy-Mask" icon.
 * <inlinegraphic fileref="gwy_mask.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_ADD:
 *
 * The "Gwy-Mask-Add" icon.
 * <inlinegraphic fileref="gwy_mask_add.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_CIRCLE:
 *
 * The "Gwy-Mask-Circle" icon.
 * <inlinegraphic fileref="gwy_mask_circle.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_CIRCLE_EXCLUSIVE:
 *
 * The "Gwy-Mask-Circle-Exclusive" icon.
 * <inlinegraphic fileref="gwy_mask_circle_exclusive.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_CIRCLE_INCLUSIVE:
 *
 * The "Gwy-Mask-Circle-Inclusive" icon.
 * <inlinegraphic fileref="gwy_mask_circle_inclusive.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_DISTRIBUTE:
 *
 * The "Gwy-Mask-Distribute" icon.
 * <inlinegraphic fileref="gwy_mask_distribute.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_EDITOR:
 *
 * The "Gwy-Mask-Editor" icon.
 * <inlinegraphic fileref="gwy_mask_editor.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_EXCLUDE:
 *
 * The "Gwy-Mask-Exclude" icon.
 * <inlinegraphic fileref="gwy_mask_exclude.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_EXCLUDE_CIRCLE:
 *
 * The "Gwy-Mask-Exclude-Circle" icon.
 * <inlinegraphic fileref="gwy_mask_exclude_circle.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_EXTRACT:
 *
 * The "Gwy-Mask-Extract" icon.
 * <inlinegraphic fileref="gwy_mask_extract.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_FILL_DRAW:
 *
 * The "Gwy-Mask-Fill-Draw" icon.
 * <inlinegraphic fileref="gwy_mask_fill_draw.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_FILL_ERASE:
 *
 * The "Gwy-Mask-Fill-Erase" icon.
 * <inlinegraphic fileref="gwy_mask_fill_erase.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_GROW:
 *
 * The "Gwy-Mask-Grow" icon.
 * <inlinegraphic fileref="gwy_mask_grow.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_INTERSECT:
 *
 * The "Gwy-Mask-Intersect" icon.
 * <inlinegraphic fileref="gwy_mask_intersect.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_INVERT:
 *
 * The "Gwy-Mask-Invert" icon.
 * <inlinegraphic fileref="gwy_mask_invert.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_LINE:
 *
 * The "Gwy-Mask-Line" icon.
 * <inlinegraphic fileref="gwy_mask_line.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_MORPH:
 *
 * The "Gwy-Mask-Morph" icon.
 * <inlinegraphic fileref="gwy_mask_morph.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_NOISIFY:
 *
 * The "Gwy-Mask-Noisify" icon.
 * <inlinegraphic fileref="gwy_mask_noisify.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_PAINT_DRAW:
 *
 * The "Gwy-Mask-Paint-Draw" icon.
 * <inlinegraphic fileref="gwy_mask_paint_draw.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_PAINT_ERASE:
 *
 * The "Gwy-Mask-Paint-Erase" icon.
 * <inlinegraphic fileref="gwy_mask_paint_erase.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_RECT_EXCLUSIVE:
 *
 * The "Gwy-Mask-Rect-Exclusive" icon.
 * <inlinegraphic fileref="gwy_mask_rect_exclusive.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_RECT_INCLUSIVE:
 *
 * The "Gwy-Mask-Rect-Inclusive" icon.
 * <inlinegraphic fileref="gwy_mask_rect_inclusive.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_REMOVE:
 *
 * The "Gwy-Mask-Remove" icon.
 * <inlinegraphic fileref="gwy_mask_remove.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_SET:
 *
 * The "Gwy-Mask-Set" icon.
 * <inlinegraphic fileref="gwy_mask_set.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_SHIFT:
 *
 * The "Gwy-Mask-Shift" icon.
 * <inlinegraphic fileref="gwy_mask_shift.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_SHRINK:
 *
 * The "Gwy-Mask-Shrink" icon.
 * <inlinegraphic fileref="gwy_mask_shrink.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_SUBTRACT:
 *
 * The "Gwy-Mask-Subtract" icon.
 * <inlinegraphic fileref="gwy_mask_subtract.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MASK_THIN:
 *
 * The "Gwy-Mask-Thin" icon.
 * <inlinegraphic fileref="gwy_mask_thin.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MEASURE_LATTICE:
 *
 * The "Gwy-Measure-Lattice" icon.
 * <inlinegraphic fileref="gwy_measure_lattice.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MERGE:
 *
 * The "Gwy-Merge" icon.
 * <inlinegraphic fileref="gwy_merge.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MFM_CONVERT_TO_FORCE:
 *
 * The "Gwy-MFM-Convert-To-Force" icon.
 * <inlinegraphic fileref="gwy_mfm_convert_to_force.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MFM_CURRENT_LINE:
 *
 * The "Gwy-MFM-Current-Line" icon.
 * <inlinegraphic fileref="gwy_mfm_current_line.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MFM_FIELD_FIND_SHIFT:
 *
 * The "Gwy-MFM-Field-Find-Shift" icon.
 * <inlinegraphic fileref="gwy_mfm_field_find_shift.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MFM_FIELD_SHIFT:
 *
 * The "Gwy-MFM-Field-Shift" icon.
 * <inlinegraphic fileref="gwy_mfm_field_shift.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MFM_PARALLEL:
 *
 * The "Gwy-MFM-Parallel" icon.
 * <inlinegraphic fileref="gwy_mfm_parallel.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MFM_PERPENDICULAR:
 *
 * The "Gwy-MFM-Perpendicular" icon.
 * <inlinegraphic fileref="gwy_mfm_perpendicular.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MORE:
 *
 * The "Gwy-More" icon.
 * <inlinegraphic fileref="gwy_more.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_MUTUAL_CROP:
 *
 * The "Gwy-Mutual-Crop" icon.
 * <inlinegraphic fileref="gwy_mutual_crop.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_NEURAL_APPLY:
 *
 * The "Gwy-Neural-Apply" icon.
 * <inlinegraphic fileref="gwy_neural_apply.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_NEURAL_TRAIN:
 *
 * The "Gwy-Neural-Train" icon.
 * <inlinegraphic fileref="gwy_neural_train.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_NEXT:
 *
 * The "Gwy-Next" icon.
 * <inlinegraphic fileref="gwy_next.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_NULL_OFFSETS:
 *
 * The "Gwy-Null-Offsets" icon.
 * <inlinegraphic fileref="gwy_null_offsets.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PALETTES:
 *
 * The "Gwy-Palettes" icon.
 * <inlinegraphic fileref="gwy_palettes.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PATH_LEVEL:
 *
 * The "Gwy-Path-Level" icon.
 * <inlinegraphic fileref="gwy_path_level.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PERSPECTIVE_DISTORT:
 *
 * The "Gwy-Perspective-Distort" icon.
 * <inlinegraphic fileref="gwy_perspective_distort.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_POINTER_MEASURE:
 *
 * The "Gwy-Pointer-Measure" icon.
 * <inlinegraphic fileref="gwy_pointer_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_POLY_DISTORT:
 *
 * The "Gwy-Poly-Distort" icon.
 * <inlinegraphic fileref="gwy_poly_distort.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_POLYNOM:
 *
 * The "Gwy-Polynom" icon.
 * <inlinegraphic fileref="gwy_polynom.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_POLYNOM_LEVEL:
 *
 * The "Gwy-Polynom-Level" icon.
 * <inlinegraphic fileref="gwy_polynom_level.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PREVIOUS:
 *
 * The "Gwy-Previous" icon.
 * <inlinegraphic fileref="gwy_previous.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PROFILE:
 *
 * The "Gwy-Profile" icon.
 * <inlinegraphic fileref="gwy_profile.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PROFILE_MULTIPLE:
 *
 * The "Gwy-Profile-Multiple" icon.
 * <inlinegraphic fileref="gwy_profile_multiple.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PSDF_LOG_PHI:
 *
 * The "Gwy-PSDF-Log-Phi" icon.
 * <inlinegraphic fileref="gwy_psdf_log_phi.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PSDF_SECTION:
 *
 * The "Gwy-PSDF-Section" icon.
 * <inlinegraphic fileref="gwy_psdf_section.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_PYGWY:
 *
 * The "Gwy-Pygwy" icon.
 * <inlinegraphic fileref="gwy_pygwy.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_RADIAL_PROFILE:
 *
 * The "Gwy-Radial-Profile" icon.
 * <inlinegraphic fileref="gwy_radial_profile.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_RANK_FILTER:
 *
 * The "Gwy-Rank-Filter" icon.
 * <inlinegraphic fileref="gwy_rank_filter.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_RASTERIZE:
 *
 * The "Gwy-Rasterize" icon.
 * <inlinegraphic fileref="gwy_rasterize.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_REMOVE_UNDER_MASK:
 *
 * The "Gwy-Remove-Under-Mask" icon.
 * <inlinegraphic fileref="gwy_remove_under_mask.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_REVOLVE_ARC:
 *
 * The "Gwy-Revolve-Arc" icon.
 * <inlinegraphic fileref="gwy_revolve_arc.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_REVOLVE_SPHERE:
 *
 * The "Gwy-Revolve-Sphere" icon.
 * <inlinegraphic fileref="gwy_revolve_sphere.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ROTATE:
 *
 * The "Gwy-Rotate" icon.
 * <inlinegraphic fileref="gwy_rotate.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ROTATE_180:
 *
 * The "Gwy-Rotate-180" icon.
 * <inlinegraphic fileref="gwy_rotate_180.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ROTATE_3D:
 *
 * The "Gwy-Rotate-3D" icon.
 * <inlinegraphic fileref="gwy_rotate_3d.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ROTATE_90_CCW:
 *
 * The "Gwy-Rotate-90-CCW" icon.
 * <inlinegraphic fileref="gwy_rotate_90_ccw.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ROTATE_90_CW:
 *
 * The "Gwy-Rotate-90-CW" icon.
 * <inlinegraphic fileref="gwy_rotate_90_cw.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SCALE:
 *
 * The "Gwy-Scale" icon.
 * <inlinegraphic fileref="gwy_scale.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SCALE_HORIZONTALLY:
 *
 * The "Gwy-Scale-Horizontally" icon.
 * <inlinegraphic fileref="gwy_scale_horizontally.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SCALE_VERTICALLY:
 *
 * The "Gwy-Scale-Vertically" icon.
 * <inlinegraphic fileref="gwy_scale_vertically.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SCARS:
 *
 * The "Gwy-Scars" icon.
 * <inlinegraphic fileref="gwy_scars.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SCIENTIFIC_NUMBER_FORMAT:
 *
 * The "Gwy-Scientific-Number-Format" icon.
 * <inlinegraphic fileref="gwy_scientific_number_format.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SELECTIONS:
 *
 * The "Gwy-Selections" icon.
 * <inlinegraphic fileref="gwy_selections.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SHADER:
 *
 * The "Gwy-Shader" icon.
 * <inlinegraphic fileref="gwy_shader.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SPECTRUM:
 *
 * The "Gwy-Spectrum" icon.
 * <inlinegraphic fileref="gwy_spectrum.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SPOT_REMOVE:
 *
 * The "Gwy-Spot-Remove" icon.
 * <inlinegraphic fileref="gwy_spot_remove.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SQUARE_SAMPLES:
 *
 * The "Gwy-Square-Samples" icon.
 * <inlinegraphic fileref="gwy_square_samples.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_STAT_QUANTITIES:
 *
 * The "Gwy-Stat-Quantities" icon.
 * <inlinegraphic fileref="gwy_stat_quantities.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_STITCH:
 *
 * The "Gwy-Stitch" icon.
 * <inlinegraphic fileref="gwy_stitch.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_STRAIGHTEN_PATH:
 *
 * The "Gwy-Straighten-Path" icon.
 * <inlinegraphic fileref="gwy_straighten_path.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SUBSCRIPT:
 *
 * The "Gwy-Subscript" icon.
 * <inlinegraphic fileref="gwy_subscript.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SUPERSCRIPT:
 *
 * The "Gwy-Superscript" icon.
 * <inlinegraphic fileref="gwy_superscript.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_ANNEAL:
 *
 * The "Gwy-Synthetic-Anneal" icon.
 * <inlinegraphic fileref="gwy_synthetic_anneal.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_BALLISTIC_DEPOSITION:
 *
 * The "Gwy-Synthetic-Ballistic-Deposition" icon.
 * <inlinegraphic fileref="gwy_synthetic_ballistic_deposition.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_BROWNIAN_MOTION:
 *
 * The "Gwy-Synthetic-Brownian-Motion" icon.
 * <inlinegraphic fileref="gwy_synthetic_brownian_motion.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_COLUMNAR:
 *
 * The "Gwy-Synthetic-Columnar" icon.
 * <inlinegraphic fileref="gwy_synthetic_columnar.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DIFFUSION:
 *
 * The "Gwy-Synthetic-Diffusion" icon.
 * <inlinegraphic fileref="gwy_synthetic_diffusion.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DISCS:
 *
 * The "Gwy-Synthetic-Discs" icon.
 * <inlinegraphic fileref="gwy_synthetic_discs.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DOMAINS:
 *
 * The "Gwy-Synthetic-Domains" icon.
 * <inlinegraphic fileref="gwy_synthetic_domains.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_DUNES:
 *
 * The "Gwy-Synthetic-Dunes" icon.
 * <inlinegraphic fileref="gwy_synthetic_dunes.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_FIBRES:
 *
 * The "Gwy-Synthetic-Fibres" icon.
 * <inlinegraphic fileref="gwy_synthetic_fibres.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_LATTICE:
 *
 * The "Gwy-Synthetic-Lattice" icon.
 * <inlinegraphic fileref="gwy_synthetic_lattice.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_LINE_NOISE:
 *
 * The "Gwy-Synthetic-Line-Noise" icon.
 * <inlinegraphic fileref="gwy_synthetic_line_noise.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_NOISE:
 *
 * The "Gwy-Synthetic-Noise" icon.
 * <inlinegraphic fileref="gwy_synthetic_noise.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_OBJECTS:
 *
 * The "Gwy-Synthetic-Objects" icon.
 * <inlinegraphic fileref="gwy_synthetic_objects.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PARTICLES:
 *
 * The "Gwy-Synthetic-Particles" icon.
 * <inlinegraphic fileref="gwy_synthetic_particles.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PATTERN:
 *
 * The "Gwy-Synthetic-Pattern" icon.
 * <inlinegraphic fileref="gwy_synthetic_pattern.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PHASES:
 *
 * The "Gwy-Synthetic-Phases" icon.
 * <inlinegraphic fileref="gwy_synthetic_phases.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PILEUP:
 *
 * The "Gwy-Synthetic-Pileup" icon.
 * <inlinegraphic fileref="gwy_synthetic_pileup.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_PLATEAUS:
 *
 * The "Gwy-Synthetic-Plateaus" icon.
 * <inlinegraphic fileref="gwy_synthetic_plateaus.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_SPECTRAL:
 *
 * The "Gwy-Synthetic-Spectral" icon.
 * <inlinegraphic fileref="gwy_synthetic_spectral.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_TURING_PATTERN:
 *
 * The "Gwy-Synthetic-Turing-Pattern" icon.
 * <inlinegraphic fileref="gwy_synthetic_turing_pattern.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_SYNTHETIC_WAVES:
 *
 * The "Gwy-Synthetic-Waves" icon.
 * <inlinegraphic fileref="gwy_synthetic_waves.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TERRACE_MEASURE:
 *
 * The "Gwy-Terrace-Measure" icon.
 * <inlinegraphic fileref="gwy_terrace_measure.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TILT:
 *
 * The "Gwy-Tilt" icon.
 * <inlinegraphic fileref="gwy_tilt.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_DILATION:
 *
 * The "Gwy-Tip-Dilation" icon.
 * <inlinegraphic fileref="gwy_tip_dilation.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_EROSION:
 *
 * The "Gwy-Tip-Erosion" icon.
 * <inlinegraphic fileref="gwy_tip_erosion.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_ESTIMATION:
 *
 * The "Gwy-Tip-Estimation" icon.
 * <inlinegraphic fileref="gwy_tip_estimation.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_INDENT_ANALYZE:
 *
 * The "Gwy-Tip-Indent-Analyze" icon.
 * <inlinegraphic fileref="gwy_tip_indent_analyze.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_LATERAL_FORCE:
 *
 * The "Gwy-Tip-Lateral-Force" icon.
 * <inlinegraphic fileref="gwy_tip_lateral_force.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_MAP:
 *
 * The "Gwy-Tip-Map" icon.
 * <inlinegraphic fileref="gwy_tip_map.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_MODEL:
 *
 * The "Gwy-Tip-Model" icon.
 * <inlinegraphic fileref="gwy_tip_model.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TIP_PID:
 *
 * The "Gwy-Tip-Pid" icon.
 * <inlinegraphic fileref="gwy_tip_pid.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_TRANSLATE_PERIODICALLY:
 *
 * The "Gwy-Translate-Periodically" icon.
 * <inlinegraphic fileref="gwy_translate_periodically.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_UNROTATE:
 *
 * The "Gwy-Unrotate" icon.
 * <inlinegraphic fileref="gwy_unrotate.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VALUE_INVERT:
 *
 * The "Gwy-Value-Invert" icon.
 * <inlinegraphic fileref="gwy_value_invert.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME:
 *
 * The "Gwy-Volume" icon.
 * <inlinegraphic fileref="gwy_volume.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_ARITHMETIC:
 *
 * The "Gwy-Volume-Arithmetic" icon.
 * <inlinegraphic fileref="gwy_volume_arithmetic.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_CALIBRATE:
 *
 * The "Gwy-Volume-Calibrate" icon.
 * <inlinegraphic fileref="gwy_volume_calibrate.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_DIMENSIONS:
 *
 * The "Gwy-Volume-Dimensions" icon.
 * <inlinegraphic fileref="gwy_volume_dimensions.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_FD:
 *
 * The "Gwy-Volume-FD" icon.
 * <inlinegraphic fileref="gwy_volume_fd.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_INVERT:
 *
 * The "Gwy-Volume-Invert" icon.
 * <inlinegraphic fileref="gwy_volume_invert.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_KMEANS:
 *
 * The "Gwy-Volume-Kmeans" icon.
 * <inlinegraphic fileref="gwy_volume_kmeans.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_KMEDIANS:
 *
 * The "Gwy-Volume-Kmedians" icon.
 * <inlinegraphic fileref="gwy_volume_kmedians.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_LINE_STATS:
 *
 * The "Gwy-Volume-Line-Stats" icon.
 * <inlinegraphic fileref="gwy_volume_line_stats.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_PLANE_STATS:
 *
 * The "Gwy-Volume-Plane-Stats" icon.
 * <inlinegraphic fileref="gwy_volume_plane_stats.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_SLICE:
 *
 * The "Gwy-Volume-Slice" icon.
 * <inlinegraphic fileref="gwy_volume_slice.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUME_SWAP_AXES:
 *
 * The "Gwy-Volume-Swap-Axes" icon.
 * <inlinegraphic fileref="gwy_volume_swap_axes.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUMIZE:
 *
 * The "Gwy-Volumize" icon.
 * <inlinegraphic fileref="gwy_volumize.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_VOLUMIZE_LAYERS:
 *
 * The "Gwy-Volumize-Layers" icon.
 * <inlinegraphic fileref="gwy_volumize_layers.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_WRAP_VALUE:
 *
 * The "Gwy-Wrap-Value" icon.
 * <inlinegraphic fileref="gwy_wrap_value.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_XY_DENOISE:
 *
 * The "Gwy-Xy-Denoise" icon.
 * <inlinegraphic fileref="gwy_xy_denoise.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_XYZIZE:
 *
 * The "Gwy-Xyzize" icon.
 * <inlinegraphic fileref="gwy_xyzize.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZERO_MAXIMUM:
 *
 * The "Gwy-Zero-Maximum" icon.
 * <inlinegraphic fileref="gwy_zero_maximum.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZERO_MEAN:
 *
 * The "Gwy-Zero-Mean" icon.
 * <inlinegraphic fileref="gwy_zero_mean.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZERO_UNDER_MASK:
 *
 * The "Gwy-Zero-Under-Mask" icon.
 * <inlinegraphic fileref="gwy_zero_under_mask.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZOOM_1_1:
 *
 * The "Gwy-Zoom-1:1" icon.
 * <inlinegraphic fileref="gwy_zoom_1_1.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZOOM_FIT:
 *
 * The "Gwy-Zoom-Fit" icon.
 * <inlinegraphic fileref="gwy_zoom_fit.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZOOM_IN:
 *
 * The "Gwy-Zoom-In" icon.
 * <inlinegraphic fileref="gwy_zoom_in.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_ZOOM_OUT:
 *
 * The "Gwy-Zoom-Out" icon.
 * <inlinegraphic fileref="gwy_zoom_out.svg" format="SVG"/>
 **/

/**
 * GWY_ICON_GWYDDION:
 *
 * The "Gwyddion" icon.
 * <inlinegraphic fileref="gwyddion.svg" format="SVG"/>
 **/

/* @@@ GENERATED ICON LIST END @@@ */

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
