#pragma once
/*
 *  $Id: pixbuf-render.h 29107 2026-01-08 10:34:23Z yeti-dn $
 *  Copyright (C) 2003-2026 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_PIXBUF_RENDER__
#define __GWYUI_PIXBUF_RENDER__

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgwyddion/field.h>
#include <libgwyddion/gradient.h>

typedef enum {
    GWY_COLOR_MAPPING_FULL  = 0,
    GWY_COLOR_MAPPING_FIXED = 1,
    GWY_COLOR_MAPPING_AUTO  = 2,
    GWY_COLOR_MAPPING_ADAPT = 3,
} GwyColorMappingType;

void gwy_draw_field_pixbuf_full      (GdkPixbuf *pixbuf,
                                      GwyField *field,
                                      GwyGradient *gradient);
void gwy_draw_field_pixbuf_with_range(GdkPixbuf *pixbuf,
                                      GwyField *field,
                                      GwyGradient *gradient,
                                      gdouble minimum,
                                      gdouble maximum);
void gwy_draw_field_pixbuf_adaptive  (GdkPixbuf *pixbuf,
                                      GwyField *field,
                                      GwyGradient *gradient);
void gwy_map_field_adaptive          (GwyField *field,
                                      const gdouble *z,
                                      gdouble *mapped,
                                      guint n);
void gwy_draw_field_pixbuf           (GdkPixbuf *pixbuf,
                                      GwyField *field,
                                      GwyGradient *gradient,
                                      GwyColorMappingType mapping,
                                      gdouble *minimum,
                                      gdouble *maximum);
void gwy_draw_field_pixbuf_mask      (GdkPixbuf *pixbuf,
                                      GwyField *field,
                                      const GwyRGBA *color);
void gwy_draw_nield_pixbuf_mask      (GdkPixbuf *pixbuf,
                                      GwyNield *field,
                                      const GwyRGBA *color);

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
