#pragma once
/*
 *  $Id: utils.h 29477 2026-02-14 13:29:30Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_UTILS_H__
#define __GWYUI_UTILS_H__

#include <math.h>
#include <gtk/gtk.h>
#include <libgwyui/color-button.h>

G_BEGIN_DECLS

#define gwy_adjustment_get_int(adj) ((gint)floor(gtk_adjustment_get_value(GTK_ADJUSTMENT(adj)) + 0.5))

/* TODO GTK3 remove the entire hscale set of functions after we use something better in Gwy3DWindow. The only
 * other user is roddeposit_synth.c which Petr has to port to ParamTable. */
typedef enum {
    GWY_HSCALE_DEFAULT          = 0,
    GWY_HSCALE_LOG              = 1,
    GWY_HSCALE_SQRT             = 2,
    GWY_HSCALE_LINEAR           = 3,
    GWY_HSCALE_NO_SCALE         = 6,
    GWY_HSCALE_WIDGET           = 7,
    GWY_HSCALE_WIDGET_NO_EXPAND = 8,
    GWY_HSCALE_CHECK            = 1024,
    GWY_HSCALE_SNAP             = 2048,
} GwyHScaleStyle;

typedef enum {
    GWY_RESPONSE_RESET       = 1,
    GWY_RESPONSE_UPDATE      = 2,
    GWY_RESPONSE_CLEAR       = 3,
    GWY_RESPONSE_USER        = 1024,
} GwyResponseType;

GtkWidget* gwy_gtkgrid_attach_adjbar           (GtkGrid *grid,
                                                gint row,
                                                const gchar *name,
                                                const gchar *units,
                                                GObject *pivot,
                                                GwyHScaleStyle style);
void       gwy_gtkgrid_hscale_set_sensitive    (GObject *pivot,
                                                gboolean sensitive);
GtkWidget* gwy_gtkgrid_hscale_get_scale        (GObject *pivot);
GtkWidget* gwy_gtkgrid_hscale_get_check        (GObject *pivot);
GtkWidget* gwy_gtkgrid_hscale_get_label        (GObject *pivot);
GtkWidget* gwy_gtkgrid_hscale_get_units        (GObject *pivot);
GtkWidget* gwy_gtkgrid_hscale_get_middle_widget(GObject *pivot);
void       gwy_mask_color_selector_run         (const gchar *dialog_title,
                                                GtkWindow *parent,
                                                GwyColorButton *color_button,
                                                GwyDict *container,
                                                GQuark quark);
void       gwy_list_store_row_changed          (GtkListStore *store,
                                                GtkTreeIter *iter,
                                                GtkTreePath *path,
                                                gint row);
GtkWidget* gwy_label_new_header                (const gchar *text);
GtkWidget* gwy_create_stock_button             (const gchar *label_text,
                                                const gchar *icon_name);
GtkWidget* gwy_create_tool_like_button         (const gchar *label_text,
                                                const gchar *icon_name);
GtkWidget* gwy_create_image_menu_item          (const gchar *label_text,
                                                const gchar *icon_name,
                                                gboolean always_show);
void       gwy_set_image_menu_item_icon        (GtkMenuItem *item,
                                                const gchar *icon_name);
void       gwy_set_image_menu_item_pixbuf      (GtkMenuItem *item,
                                                GdkPixbuf *pixbuf);
gboolean   gwy_widget_get_activate_on_unfocus  (GtkWidget *widget);
void       gwy_widget_set_activate_on_unfocus  (GtkWidget *widget,
                                                gboolean activate);
void       gwy_widget_sync_sensitivity         (GtkWidget *master,
                                                GtkWidget *slave);
gboolean   gwy_widget_is_hbox                  (GtkWidget *widget);
GtkWidget* gwy_add_button_to_dialog            (GtkDialog *dialog,
                                                const gchar *label_text,
                                                const gchar *icon_name,
                                                gint response_id);
void       gwy_set_message_label               (GtkLabel *label,
                                                const gchar *text,
                                                GtkMessageType type,
                                                gboolean is_markup);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
